﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using NHibernate;
using NHibernate.Expression;
using CITAD.Common;
using CITAD.Data;
using CITAD.Core;
using CITAD.Core.Domain;
using System.Collections.Generic;
using NumberToChar;

namespace CITAD.Modules.InGiayBao.Web
{
    public partial class InGiayBao1 : System.Web.UI.Page
    {
        #region "Private function"

        //==========Print===========
        private void fcnPrint(bool i_blPrint)
        {
            bool blFlag = bolCheck();
            if (!blFlag)
            {
                if (clsCommon.fcnGetMessage("IGB0011") != null)
                {
                    MessageBox1.Show("IGB0011: " + clsCommon.fcnGetMessage("IGB0011"), MessageBoxType.Warning);
                }
                else
                {
                    MessageBox1.Show("MORG114: " + clsCommon.fcnGetMessage("MORG114"), MessageBoxType.Warning);
                }
                return;
            }
            Session["BACKURL"] = "InGiayBao/InGiayBao.aspx";
            //============================================================
            if (i_blPrint) //Nút in được ấn
            {
                if (rdbNoPrint.Checked)//Chưa in
                {
                    subPrintReport(rdbDi.Checked, false);
                }
                else//Đã in
                {
                    subPrintReport(rdbDi.Checked, true);
                }
            }
            else //Nút in lại được ấn
            {
                subPrintReport(rdbDi.Checked, false);
            }

            fncQuery(0);
        }

        /// <summary>
        /// Hàm truy vấn giao dịch
        /// //O_CI_ID:ID ngân hàng gửi==>Đi
        /// //R_CI_ID:ID ngân hàng nhận==>Đến
        /// </summary>
        /// <param name="intPageIndex"></param>
        private void fncQuery(int intPageIndex)
        {
            string arrTrxType_Access = "'" + clsCommon.fcnGetTRX_TYPE_Access(Session["gstrLoginID"].ToString(), (int)CitadMenuID.InGiayBao).Replace(",", "','") + "'";
            int iTongTrang = 0;
            Menu1.Items[1].Enabled = false;
            Menu1.Items[2].Enabled = false;
            grvInGiayBao.DataSource = null;
            grvInGiayBao.DataBind();
            lblTong.Text = "0";
            lblTong.Text = clsCommon.fcnGetMessage("IGB000T") + ": 0 " + clsCommon.fcnGetMessage("IGB00T1");
            DateTime dtmTmpDate;
            if (dtpNgayGD.Text.Trim() == "")
            {
                MessageBox1.Show("MORG122: " + clsCommon.fcnGetMessage("MORG122"), MessageBoxType.Warning);
                return;
            }
            if ((dtpNgayGD.Text.Trim() != "") && (!DateTime.TryParseExact(dtpNgayGD.Text.Trim(), "dd/MM/yyyy", null, System.Globalization.DateTimeStyles.None, out dtmTmpDate)))
            {
                MessageBox1.Show("VMSG20: " + clsCommon.fcnGetMessage("Vmsg20"), MessageBoxType.Warning);
                return;
            }
            clsDAL objDAL = new clsDAL();
            string subSTR = "SUBSTR";
            if (objDAL.DataBaseType == eDataBaseType.MSSQL) subSTR = "SUBSTRING";
            else if (objDAL.DataBaseType == eDataBaseType.ORACLE) subSTR = "SUBSTR";
            string sSQL = "SELECT  '0' AS No,'' as LOAIGIAODICH," +
                                   "tblTrans.SERIAL_NO ,tblTrans.MSG_KEY ," +
                                   "tblTrans.RELATION_NO , " +
                                   "tblCI.CI_CODE , " +
                                   "tblCI.CI_NAME ," +
                                   "tblTrans.AMOUNT ," +
                                   "tblTrans.SD_TIME ," +
                                   "tblTrans.MSG_KEY " +
                           " FROM TBLTRANSACTIONMSG_ORG tblTrans  ";

            string sWhere = " tblTrans.TRX_TYPE IN(" + arrTrxType_Access + ") ";
            string sJoin = "";
            string strDate = "";
            strDate = dtpNgayGD.Text.Trim().Substring(6, 4) + dtpNgayGD.Text.Trim().Substring(3, 2) + dtpNgayGD.Text.Trim().Substring(0, 2);

            sWhere += "AND tblTrans.TRX_DATE = '" + strDate + "'";
            //điều kiện chọn Số hiệu GD
            if (txtSoHieuGD.Text.Trim() != "")
            {

                sWhere += "AND tblTrans.SERIAL_NO like '%" + txtSoHieuGD.Text.Trim() + "%'";
            }
            if (txtSoButtoan.Text.Trim() != "")
            {
                sWhere += "AND tblTrans.RELATION_NO like '%" + txtSoButtoan.Text.Trim() + "%'";
            }
            // Điều kiện ngan hàng gửi: sanghh
            //if (txtOCI_Code.Text.Trim() != "")
            //{
            //    sWhere += "AND tblTrans.O_CI_ID Like '%" + txtOCI_Code.Text.Trim() + "%'";
            //}

            //điều kiện chọn số bút toán
            if (rdbDi.Checked)
            {
                //O_CI_ID:ID ngân hàng gửi==>Đi
                sJoin += " INNER JOIN TBLCI_LIST tblCI ON tblTrans.R_CI_ID = tblCI.CI_ID ";
                sWhere += "AND " + subSTR + "(tblTrans.RESPONSE_CODE,2,3) = '000' ";
                sWhere += "AND tblTrans.RESPONSE_CODE <> '0000' ";
                //Chưa In
                if (rdbNoPrint.Checked == true)
                {
                    sWhere += "AND " + subSTR + "(tblTrans.TRX_STATUS,11,1) = '0' ";
                }
                //Đã In
                else if (rdbPrinted.Checked == true)
                {
                    sWhere += " AND " + subSTR + "(tblTrans.TRX_STATUS,11,1) <> '0' ";
                }
                sWhere += " AND tblTrans.O_CI_ID='" + Application["gstrCI_ID"].ToString() + "' ";
                if (txtOCI_Code.Text.Trim() != "")
                {
                    sWhere += " AND TBLCI.CI_CODE Like '%" + txtOCI_Code.Text.Trim() + "%' ";
                }
            }
            else if (rdbDen.Checked)
            {
                //R_CI_ID:ID ngân hàng nhận==>Đến
                sJoin += " INNER JOIN TBLCI_LIST tblCI ON tblTrans.O_CI_ID=tblCI.CI_ID ";
                //Chưa In
                sWhere += " AND NOT tblTrans.PROCESS IN (8,13) ";
                sWhere += " AND " + subSTR + "(tblTrans.RESPONSE_CODE,2,3)='000' ";
                sWhere += " AND tblTrans.RESPONSE_CODE <> '0000' ";
                if (rdbNoPrint.Checked == true)
                {
                    sWhere += " AND " + subSTR + "(tblTrans.TRX_STATUS,11,1)= '0' ";
                }
                //Đã In
                else if (rdbPrinted.Checked == true)
                {
                    sWhere += " AND " + subSTR + "(tblTrans.TRX_STATUS,11,1)<> '0' ";
                }
                sWhere += " AND tblTrans.R_CI_ID='" + Application["gstrCI_ID"].ToString() + "' ";
                // Điều kiện ngan hàng gửi: sanghh
                if (txtOCI_Code.Text.Trim() != "")
                {
                    sWhere += " AND TBLCI.CI_CODE Like '%" + txtOCI_Code.Text.Trim() + "%' ";
                }
            }
            if (sWhere != string.Empty)
            {
                sSQL = sSQL + sJoin;
                sSQL = sSQL + " WHERE " + sWhere;
            }

            //chinh-px: 20081120 start
            //sSQL = sSQL + " ORDER BY tblTrans.RELATION_NO ";
            //chinh-px: 20081120 end
            //===================================================================
            string v_strOrderString = CitadSortGrid.OrderString(objDAL.DataBaseType, ViewState);
            if (v_strOrderString != "")
            {
                sSQL += " ORDER BY " + v_strOrderString;
            }

            //===================================================================
            DataSet dsShowList = new DataSet();
            dsShowList = objDAL.fcnExecQuery(sSQL);
            if (dsShowList.Tables[0] != null)
            {
                if (dsShowList.Tables[0].Rows.Count > 0)
                {
                    int iNo = 0;

                    foreach (DataRow row in dsShowList.Tables[0].Rows)
                    {
                        row["No"] = iNo + 1;
                        iNo++;
                        string strTYPE = row["MSG_KEY"].ToString().Substring(0, 2);
                        // Cột loại giao dịch
                        if ("PA,LF,LN".IndexOf(strTYPE) > -1)
                        {
                            row["LOAIGIAODICH"] = clsCommon.fcnGetMessage("Trxmsg47");
                        }
                        else if ("HF,HP,PN,HN".IndexOf(strTYPE) > -1)
                        {
                            row["LOAIGIAODICH"] = clsCommon.fcnGetMessage("Trxmsg48");
                        }
                        if (row["AMOUNT"] != DBNull.Value) row["AMOUNT"] = clsCommon.fcnFomatAmount(row["AMOUNT"]);
                        if ((row["SD_TIME"] != DBNull.Value) && (row["SD_TIME"].ToString().Length == 14)) row["SD_TIME"] = row["SD_TIME"].ToString().Substring(8, 2) + ":" + row["SD_TIME"].ToString().Substring(10, 2) + ":" + row["SD_TIME"].ToString().Substring(12, 2);
                    }

                    dsShowList.Tables[0].AcceptChanges();

                    grvInGiayBao.DataSource = dsShowList;
                    grvInGiayBao.PageIndex = intPageIndex;
                    grvInGiayBao.DataBind();

                    if (rdbNoPrint.Checked == true)
                    {
                        Menu1.Items[1].Enabled = true;
                        Menu1.Items[2].Enabled = false;
                    }
                    else
                    {
                        int v_intMENU_ID = (int)CitadMenuID.KiemSoatLenhChuyenTien;

                        string v_strARR_MENU_ID = "," + clsCommon.fcnGetMenuAccess((string)Session["gstrLoginID"]) + ",";
                        Menu1.Items[1].Enabled = true;
                        Menu1.Items[2].Enabled = v_strARR_MENU_ID.Contains("," + v_intMENU_ID + ",");
                    }

                }
                int iTrans = dsShowList.Tables[0].Rows.Count;
                lblTong.Text = clsCommon.fcnGetMessage("IGB000T") + ": " + iTrans + " " + clsCommon.fcnGetMessage("IGB00T1");
            }
        }


        private void subUpdatePrinter(string i_strMSG_KEY)
        {
            string sResult = "";
            //Cập nhật đã in
            //if (rdbPrinted.Checked == true)
            //{
            //    //Cập nhật giao dịch trạng thái đã in ở vị trí thứ 11,12 là 1
            //    sResult = "00";
            //}
            //Cập nhật chưa in
            if (rdbNoPrint.Checked)
            {
                //Cập nhật giao dịch trạng thái chưa in ở vị trí thứ 11,12 là 0
                sResult = "11";
            }
            else
            {
                return;
            }

            TBLTRANSACTIONMSG_ORGModule mdlTrans = new TBLTRANSACTIONMSG_ORGModule();
            TBLTRANSACTIONMSG_ORG objTrans = new TBLTRANSACTIONMSG_ORG();
            mdlTrans.BeginTransaction();

            int v_intTryCount = 0;
            while (v_intTryCount < 5)
            {
                try
                {
                    mdlTrans.BeginTransaction();
                    objTrans = mdlTrans.GetById(i_strMSG_KEY, true);
                    break;
                }
                catch (Exception ex)
                {
                    mdlTrans.Rollback();
                    v_intTryCount++;
                    return;
                }
            }
            try
            {
                objTrans.TRX_STATUS = objTrans.TRX_STATUS.Substring(0, 10) + sResult + objTrans.TRX_STATUS.Substring(12, 3);

                string v_strMessageContent = clsCommon.fcnMakeMessage(objTrans);
                if (v_strMessageContent == "")
                {
                    clsCommon.fcnWriteLogFileBankCode("InGiayBao.subUpdatePrinter", objTrans.SERIAL_NO + "MakeMessage null");
                    return;
                }
                objTrans.MAC = clsCommon.fcnCreateMAC(v_strMessageContent, objTrans.TRX_STATUS, (int)objTrans.PROCESS, objTrans.APPR_IN_ID, objTrans.APPR_IN_TIME);

                mdlTrans.Update(objTrans);
                mdlTrans.Commit();
            }
            catch (Exception ex)
            {
                mdlTrans.Rollback();
            }
        }

        //cuongvv 20091110 Cập nhật trạng thái GD sai MAC để cập nhật lại file
        private void subUpdateTrxStatusFalse(string i_strMSG_KEY)
        {
            TBLTRANSACTIONMSG_ORGModule mdlTBLTRANSACTIONMSG_ORG = new TBLTRANSACTIONMSG_ORGModule();
            TBLTRANSACTIONMSG_ORG objTrx = new TBLTRANSACTIONMSG_ORG();
            mdlTBLTRANSACTIONMSG_ORG.BeginTransaction();

            int v_intTryCount = 0;
            while (v_intTryCount < 5)
            {
                try
                {
                    mdlTBLTRANSACTIONMSG_ORG.BeginTransaction();
                    objTrx = mdlTBLTRANSACTIONMSG_ORG.GetById(i_strMSG_KEY, true);
                    break;
                }
                catch (Exception ex)
                {
                    mdlTBLTRANSACTIONMSG_ORG.Rollback();
                    v_intTryCount++;
                    return;
                }
            }
            try
            {
                string v_strMessageContent = clsCommon.fcnMakeMessage(objTrx);
                if (v_strMessageContent == "")
                {
                    clsCommon.fcnWriteLogFileBankCode("InGiayBao.subUpdateTrxStatusFalse", objTrx.SERIAL_NO + "MakeMessage null");
                    return;
                }
                objTrx.PROCESS = 8;
                objTrx.TRX_STATUS = "000000000000000";
                mdlTBLTRANSACTIONMSG_ORG.Update(objTrx);
                mdlTBLTRANSACTIONMSG_ORG.Commit();
                string strMessage = "SERIAL_NO:" + objTrx.SERIAL_NO + " PROCESS:" + objTrx.PROCESS + " TRX_STATUS:" + objTrx.TRX_STATUS;
                clsCommon.fcnWriteLogFileBankCode("InGiayBao.subUpdateTrxStatusFalse GD sai MAC:", strMessage);
            }
            catch (Exception ex)
            {
                clsCommon.fcnWriteLogFileBankCode("InGiayBao.subUpdateTrxStatusFalse GD sai MAC Exception ", ex.Message);
                mdlTBLTRANSACTIONMSG_ORG.Rollback();
            }
        }


        private bool bolCheck()
        {

            for (int i = 0; i < grvInGiayBao.Rows.Count; i++)
            {
                GridViewRow gRow = grvInGiayBao.Rows[i];
                HtmlInputCheckBox check = (HtmlInputCheckBox)(gRow.FindControl("chkOne"));
                if (check.Checked == true)
                {
                    return true;
                }

            }
            return false;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="i_blIsOUT">Chiều đi : true; Chiều đến: false</param>
        /// <param name="i_blIsCopy">Bản sao: true; Bản chính: false</param>
        private void subPrintReport(bool i_blIsOUT, bool i_blIsCopy)
        {
            try
            {
                //===================================================
                //Kiểm tra ngân hàng hiện tại là hội sở chính và nhà nước
                //CI_TYPE='H' AND CI_CLASS='S'
                bool v_blIsCI_HO = false;
                TBLCI_LISTModule mdlTBLCI_LIST = new TBLCI_LISTModule();
                TBLCI_LIST objTBLCI_LIST = new TBLCI_LIST();
                objTBLCI_LIST = mdlTBLCI_LIST.GetById(Convert.ToInt64(Application["gstrCI_ID"].ToString()));

                v_blIsCI_HO = objTBLCI_LIST.CI_TYPE == "H" && objTBLCI_LIST.CI_CLASS == "S";
                //===================================================

                string v_strSQL = "";
                string strSerialNo_SaiMac = "";
                TBLTRANSACTIONMSG_ORGModule mdlTRANSACTIONMSG_ORG = new TBLTRANSACTIONMSG_ORGModule();
                TBLTRANSACTIONMSG_ORG tblTrx;

                clsDAL objDAL = new clsDAL();
                string v_strNAME_E_V = "NAME_V";
                if (Session["gstrLanguage"].ToString() == CitadLanguage.en)
                {
                    v_strNAME_E_V = "NAME_E";
                }

                string v_strJOIN_USER_ID = "APPR_ID";
                // string v_SD_TIME = "SD_TIME";
                if (rdbDen.Checked)
                {
                    v_strJOIN_USER_ID = "APPR_IN_ID";
                    //v_SD_TIME = "BALANCE_TIME";
                }

                v_strSQL = "SELECT O.TAX_CODE AS MSG_KEY,O.TRX_DATE,TBLCI_LIST.CI_NAME AS TenNHGui, TBLCI_LIST.CI_CODE AS MaNHGui," +
                                 " TBLCI_LIST_1.CI_CODE AS MaNHNhan, TBLCI_LIST_1.CI_NAME AS TenNHNhan," +
                                 " TBLCI_LIST_2.CI_CODE AS MaNHGuiUQ, TBLCI_LIST_2.CI_NAME AS TenNHGuiUQ," +
                                 " TBLCI_LIST_3.CI_CODE AS MaNHNhanUQ, TBLCI_LIST_3.CI_NAME AS TenNHNhanUQ," +
                                 " O.APPR_ID AS MaKS, S." + v_strNAME_E_V + " AS LoaiGD," +
                                 " O.SERIAL_NO AS SoHieuGD,O.RELATION_NO AS SoButoan," +
                                 " O.SD_NAME AS TenNguoiGui," +
                                 " O.SD_ADDR AS DiaChiNguoiGui," +
                                 " O.REFERENCE AS CMND_NguoiGui," +
                                 " O.SD_ACCNT AS TaiKhoan_NguoiGui," +
                                 " O.RV_NAME AS TenNguoiNhan," +
                                 " O.RV_ADDR AS DiaChiNguoiNhan," +
                                 " O.RV_ACCNT AS TaiKhoan_NguoiNhan," +                                 
                                 " O.CONTENT AS NoiDung, O.AMOUNT AS SoTien," +
                                 " O.APPR_IN_TIME," +
                                 " O.REFERENCE," +
                                 " O.CONTENT_EX," +
                                 " '' AS NDG1, '' AS NDK1, '' AS MCH1, '' as STN1," +
                                 "'' AS NDG2, '' AS NDK2, '' AS MCH2, '' as STN2,'' AS NDG3, '' AS NDK3, '' AS MCH3, '' as STN3,"+
                                 "'' AS NDG4, '' AS NDK4, '' AS MCH4, '' as STN4,'' AS NDG5, '' AS NDK5, '' AS MCH5, '' as STN5,"+
                                 "'' AS MST, '' AS CQT, '' AS TCQ, '' AS LTH, '' AS NNT, '' AS SKH, '' AS SMA,"+
                                 "'' AS STK, '' AS NTK, '' AS XNK, '' AS CQP, '' AS TKH,"+
                                 " O.SD_TIME,BALANCE_TIME AS ThoiGianNhan,'' AS TKNo," +
                                 " '' AS TKCo,'' AS LenhChuyenCo,'' AS NgayGioLap_Label,O.TRX_DATE AS ThoiGianIn," +
                                 " '' AS SoTienBangChu,O.O_CI_ID,O.R_CI_ID,O.O_INDIRECT_ID,O.R_INDIRECT_ID,O.OPERT2," +
                                 " TBLUSER.USER_NAME AS CMND_NguoiNhan" +
                                 " FROM TBLTRANSACTIONMSG_ORG O" +
                                 " INNER JOIN TBLSERVICE_LIST S ON O.TRX_TYPE = S.TRX_TYPE " +
                                 " INNER JOIN TBLCI_LIST ON TBLCI_LIST.CI_ID = O.O_CI_ID " +
                                 " INNER JOIN TBLCI_LIST TBLCI_LIST_1 ON O.R_CI_ID = TBLCI_LIST_1.CI_ID " +
                                 " INNER JOIN TBLCI_LIST TBLCI_LIST_2 ON O.O_INDIRECT_ID = TBLCI_LIST_2.CI_ID " +
                                 " INNER JOIN TBLCI_LIST TBLCI_LIST_3 ON O.R_INDIRECT_ID = TBLCI_LIST_3.CI_ID " +
                                 " LEFT JOIN TBLUSER ON TBLUSER.USER_ID = O." + v_strJOIN_USER_ID;

                string[] par = new string[63];
                string[] parV = new string[63];

                par[0]  = "paraBanSao";
                par[1]  = "prThanhToanDienTuLienNganHang";
                par[2]  = "prMaKS";
                par[3]  = "prLoaiGiaoDich";
                par[4]  = "prSoButToan";
                par[5]  = "prThoiDiemTrungTamXL";
                par[6]  = "prMaNH";
                par[7]  = "prNguoiPhatLenh";
                par[8]  = "prNguoiNhanLenh";
                par[9]  = "prTaiKhoan";
                par[10] = "prNganHang";
                par[11] = "prNoiDung";
                par[12] = "prSoTienBangSo";
                par[13] = "prSoTienBangChu";
                par[14] = "prKeToan";
                par[15] = "prKiemSoat";
                par[16] = "prChuTaiKhoan";
                par[17] = "prDiaChi";
                par[18] = "prCMND";
                par[19] = "prSoHieuGiaoDich";
                par[20] = "prNganHangGui";
                par[21] = "prNganHangNhan";
                par[22] = "prChuTaiKhoan";
                par[23] = "prPageBreak";        //In trên 1 trang hay ko, nhận giá trị "1"/"0"
                par[24] = "prNumberCopy";       //Số liên
                par[25] = "prMaSoThue";         //Mã Số thuế
                par[26] = "prMauSo";            //Mẫu số TTLNH-04

                par[27] = "prREFERENCE";

                par[28] = "prIsOut";
                par[29] = "prTrxDate";
                par[30] = "prSD_Time";
                par[31] = "prMST";
                par[32] = "prMaCQT";
                par[33] = "prTenCQT";
                par[34] = "prTaxType";
                par[35] = "prTaxDate";
                par[36] = "prSKH";
                par[37] = "prSMA";
                par[38] = "prSTK";
                par[39] = "prNTK";
                par[40] = "prXNK";
                par[41] = "prCQP";
                par[42] = "prTKH";

                par[43] = "prNDG1";
                par[44] = "prNDG2";
                par[45] = "prNDG3";
                par[46] = "prNDG4";
                par[47] = "prNDG5";

                par[48] = "prNDK1";
                par[49] = "prNDK2";
                par[50] = "prNDK3";
                par[51] = "prNDK4";
                par[52] = "prNDK5";

                par[53] = "prMCH1";
                par[54] = "prMCH2";
                par[55] = "prMCH3";
                par[56] = "prMCH4";
                par[57] = "prMCH5";

                par[58] = "prSTN1";
                par[59] = "prSTN2";
                par[60] = "prSTN3";
                par[61] = "prSTN4";
                par[62] = "prSTN5";

                //=====================================================
                ArrayList arrID = new ArrayList();
                string v_strArrID = "";
                string v_strID = "";
                bool v_blIsRightMAC = false;
                foreach (GridViewRow row in grvInGiayBao.Rows)
                {
                    HtmlInputCheckBox v_chkTMP = (HtmlInputCheckBox)(row.FindControl("chkOne"));
                    if (!v_chkTMP.Checked) //Không đc chọn thì out luôn
                    {
                        continue;
                    }

                    v_strID = grvInGiayBao.DataKeys[row.RowIndex].Value.ToString();
                    tblTrx = mdlTRANSACTIONMSG_ORG.GetById(v_strID);

                    //cuongvv Rem kiểm tra MAC cả bản chính và bản sao
                    //if (i_blIsCopy) //Bản sao thì ko kiểm tra MAC
                    //{
                    //    v_blIsRightMAC = true;
                    //}
                    //else
                    //{
                    //    v_blIsRightMAC = clsCommon.fcnCheckMAC(tblTrx);
                    //}
                    v_blIsRightMAC = clsCommon.fcnCheckMAC(tblTrx);

                    //cuongvv Test in
                    //v_blIsRightMAC = true;

                    if (v_blIsRightMAC)
                    {
                        v_strArrID += "," + "'" + v_strID + "'";
                        arrID.Add(v_strID);
                    }
                    else
                    {
                        //cuongvv 20091113
                        if (rdbDen.Checked)
                        {
                            string sTRX = "";
                            sTRX = " O_CI_ID:" + tblTrx.O_CI_ID + " R_CI_ID:" + tblTrx.R_CI_ID + " SERIAL_NO:" + tblTrx.SERIAL_NO + " DATE:" + tblTrx.TRX_DATE;

                            // cập nhật GD thanh chưa kiểm soát de cap nhat lai file
                            subUpdateTrxStatusFalse(v_strID.ToString());
                            clsCommon.fcnWriteLogFileBankCode("InGiayBao.subPrintReport GD sai MAC => reUpdate status:", sTRX);
                            strSerialNo_SaiMac += ", " + "'" + tblTrx.SERIAL_NO + "'";
                        }
                        else
                        {
                            string sTRX = "";
                            sTRX = " O_CI_ID:" + tblTrx.O_CI_ID + " R_CI_ID:" + tblTrx.R_CI_ID + " SERIAL_NO:" + tblTrx.SERIAL_NO + " DATE:" + tblTrx.TRX_DATE;
                            clsCommon.fcnWriteLogFileBankCode("InGiayBao.subPrintReport GD đi sai MAC ", sTRX);
                            strSerialNo_SaiMac += ", " + "'" + tblTrx.SERIAL_NO + "'";
                        }
                        //strSerialNo_SaiMac += ", " + "'" + tblTrx.SERIAL_NO + "'";
                        //clsCommon.fcnWriteLogFileBankCode("InGiayBao.subPrintReport", "Giao dịch sai MAC in giấy báo");
                        //cuongvv 20091113
                    }
                }

                if (v_strArrID == "")
                {
                    if (strSerialNo_SaiMac != "")
                    {
                        if (rdbDen.Checked)
                        {
                            strSerialNo_SaiMac = strSerialNo_SaiMac.Substring(2);
                            MessageBox1.Show("MORG128: " + clsCommon.fcnGetMessage("MORG128") + " Hãy cập nhật lại file chứa các giao dịch này sau đó kiểm soát lại: " + strSerialNo_SaiMac, MessageBoxType.Warning);
                        }
                        else
                        {
                            strSerialNo_SaiMac = strSerialNo_SaiMac.Substring(2);
                            MessageBox1.Show("MORG128: " + clsCommon.fcnGetMessage("MORG128") + " Hãy kiểm tra lại các giao dịch này: " + strSerialNo_SaiMac, MessageBoxType.Warning);
                        }
                    }
                    return;
                }
                else
                {
                    v_strArrID = v_strArrID.Substring(1);
                }

                v_strSQL = v_strSQL + " WHERE O.MSG_KEY IN (" + v_strArrID + ")";

                string v_strOrderString = CitadSortGrid.OrderString(objDAL.DataBaseType, ViewState);
                if (v_strOrderString != "")
                {
                    v_strSQL += " ORDER BY " + v_strOrderString;
                    if (!v_strOrderString.Contains("RELATION_NO"))
                    {
                        v_strSQL += ", RELATION_NO ASC";
                    }
                }
                DataSet ds = new DataSet();
                ds = objDAL.fcnExecQuery(v_strSQL);
                             

                //=================================================================
                //  value
                parV[1] = clsCommon.fcnGetMessage("rptThanhToanDienTuLienNganHang").ToUpper();
                parV[2] = clsCommon.fcnGetMessage("rptMaKS");
                if (parV[2].Trim().Substring(parV[2].Trim().Length - 1, 1) != ":") parV[2] += ":";

                parV[3] = clsCommon.fcnGetMessage("rptLoaiGiaoDich");
                if (parV[3].Trim().Substring(parV[3].Trim().Length - 1, 1) != ":") parV[3] += ":";

                parV[4] = clsCommon.fcnGetMessage("rptSoButToan");
                if (parV[4].Trim().Substring(parV[4].Trim().Length - 1, 1) != ":") parV[4] += ":";

                parV[5] = clsCommon.fcnGetMessage("rptThoiDiemTrungTamXL");
                if (parV[5].Trim().Substring(parV[5].Trim().Length - 1, 1) != ":") parV[5] += ":";

                parV[6] = clsCommon.fcnGetMessage("rptMaNH");
                if (parV[6].Trim().Substring(parV[6].Trim().Length - 1, 1) != ":") parV[6] += ":";

                parV[7] = clsCommon.fcnGetMessage("rptNguoiPhatLenh");
                if (parV[7].Trim().Substring(parV[7].Trim().Length - 1, 1) != ":") parV[7] += ":";

                parV[8] = clsCommon.fcnGetMessage("rptNguoiNhanLenh");
                if (parV[8].Trim().Substring(parV[8].Trim().Length - 1, 1) != ":") parV[8] += ":";

                parV[9] = clsCommon.fcnGetMessage("rptTaiKhoan");
                if (parV[9].Trim().Substring(parV[9].Trim().Length - 1, 1) != ":") parV[9] += ":";

                parV[10] = clsCommon.fcnGetMessage("rptTaiNH");
                if (parV[10].Trim().Substring(parV[10].Trim().Length - 1, 1) != ":") parV[10] += ":";

                parV[11] = clsCommon.fcnGetMessage("rptNoiDung");
                if (parV[11].Trim().Substring(parV[11].Trim().Length - 1, 1) != ":") parV[11] += ":";

                parV[12] = clsCommon.fcnGetMessage("rptSoTienBangSo");
                if (parV[12].Trim().Substring(parV[12].Trim().Length - 1, 1) != ":") parV[12] += ":";

                parV[13] = clsCommon.fcnGetMessage("rptSoTienBangChu");
                if (parV[13].Trim().Substring(parV[13].Trim().Length - 1, 1) != ":") parV[13] += ":";

                parV[14] = clsCommon.fcnGetMessage("rptKeToan").ToUpper();
                parV[15] = clsCommon.fcnGetMessage("rptKiemSoat").ToUpper();
                parV[16] = clsCommon.fcnGetMessage("rptChuTaiKhoan").ToUpper();
                parV[17] = clsCommon.fcnGetMessage("rptDiaChiCMND");
                if (parV[17].Trim().Substring(parV[17].Trim().Length - 1, 1) != ":") parV[17] += ":";

                parV[18] = clsCommon.fcnGetMessage("rptChuongLoaiKhoanMuc") + ":";
                parV[19] = clsCommon.fcnGetMessage("rptSoHieuGiaoDich");
                if (parV[19].Trim().Substring(parV[19].Trim().Length - 1, 1) != ":") parV[19] += ":";

                parV[20] = clsCommon.fcnGetMessage("rptNganHangGui");
                if (parV[20].Trim().Substring(parV[20].Trim().Length - 1, 1) != ":") parV[20] += ":";

                parV[21] = clsCommon.fcnGetMessage("rptNganHangNhan");
                if (parV[21].Trim().Substring(parV[21].Trim().Length - 1, 1) != ":") parV[21] += ":";

                parV[22] = clsCommon.fcnGetMessage("rptChuTaiKhoan").ToUpper();

                //==============================================================
                //Cập nhật tình trạng đã in
                if (i_blIsCopy)
                {
                    parV[0] = clsCommon.fcnGetMessage("rptBanSao");
                }
                else
                {
                    parV[0] = "";
                    for (int i = 0; i < arrID.Count; i++)
                    {
                        subUpdatePrinter(arrID[i].ToString());
                    }
                }
                //==============================================================
                //THêm dịch vụ
                string v_strCI_ID = Application["gstrCI_ID"].ToString();
                
                //Cuongvv 20101208 rem
                //bool v_bl_Right = clsCommon.fcnDV_VerifyMACBankRight(v_strCI_ID, CitadSortList.AUTO_APPROVE);
                //if (v_bl_Right)

                //Cuongvv 20101208 cho phép NHNN được in theo số bản
                if (v_strCI_ID.Substring(2, 3) == "101")
                {
                    if (i_blIsOUT) // Chiều đi
                    {
                        parV[23] = clsCommon.fcnGetENVControl("IN_1TRANG_DI", "0");//In trên 1 trang hay ko, nhận giá trị "1"/"0"
                        if (i_blIsCopy)
                        {
                            parV[24] = clsCommon.fcnGetENVControl("IN_SOLIENBANSAO_DI", "1");
                        }
                        else
                        {
                            parV[24] = clsCommon.fcnGetENVControl("IN_SOLIENBANCHINH_DI", "1");
                        }
                    }
                    else //Chiều đến
                    {
                        parV[23] = clsCommon.fcnGetENVControl("IN_1TRANG_DEN", "0");//In trên 1 trang hay ko, nhận giá trị "1"/"0"
                        if (i_blIsCopy)
                        {
                            parV[24] = clsCommon.fcnGetENVControl("IN_SOLIENBANSAO_DEN", "2");
                        }
                        else
                        {
                            parV[24] = clsCommon.fcnGetENVControl("IN_SOLIENBANCHINH_DEN", "2");
                        }
                    }
                }
                else
                {
                    parV[23] = "0";//In trên 1 trang hay ko, nhận giá trị "1"/"0"
                    parV[24] = i_blIsOUT ? "1" : "2";

                    //if(ds[])
                }
                // Cuongvv
                parV[25] = "Mã số thuế:";
                parV[26] = "TTLNH-04";
                                
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    // CuongVV 13/03/2012 ===================================================
                    string strOPER2 = dr["OPERT2"].ToString();
                    TBLOPERATION2 tblOPRT2 = (new TBLOPERATION2Module()).GetById(strOPER2);
                    //kiem tra neu loai nghiep vu 2 != 100, 101 
                    //truong hop thong tin giao dich tren thi truong LNH
                    if (tblOPRT2 == null)
                    {
                        parV[27] = "";
                    }
                    else
                    {
                        parV[27] = dr["cmnd_nguoigui"].ToString();
                    }                    
                    
                    // Cuongvv 20100915 sửa theo Y/C của ITDB lấy ngày GD+Thời gian gửi để in
                    //Thời điểm xử lý
                    //if (dr["ThoiGianIn"].ToString() == 14)
                    
                    //Cuongvv added 20101217
                    if (dr["ThoiGianIn"].ToString() != "")  //Ngay GD
                    {
                        //Cuongvv rem 20101217 dr["ThoiGianIn"] = clsCommon.fcnDateExact(dr["ThoiGianIn"].ToString() + (dr["SD_TIME"].ToString()).Substring(8, 6)).ToString("dd/MM/yyyy");
                        //dr["ThoiGianIn"] = clsCommon.fcnDateExact(dr["ThoiGianIn"] + sDateTimeIncom).ToString("dd/MM/yyyy");
                        dr["ThoiGianIn"] = clsCommon.fcnShortDateExact(dr["ThoiGianIn"].ToString()).ToString("dd/MM/yyyy");
                    }
                    else
                    {
                        dr["ThoiGianIn"] = clsCommon.fcnShortDateExact(dr["TRX_DATE"].ToString()).ToString("dd/MM/yyyy");  
                    }                       
               
                    //Thời điểm gửi/nhận lệnh
                    //if (dr["SD_TIME"].ToString() != "")
                    //{
                    //    dr["SD_TIME"] = clsCommon.fcnDateExact(dr["SD_TIME"].ToString()).ToString("dd/MM/yyyy HH:mm:ss");
                    //}

                    //Cuongvv added 20101217 GD đi: SD_TIME=Thời gian gửi; GD đến: ThoiGianNhan: Thời gian nhận
                    //if (dr["SD_TIME"].ToString() != "")
                    //{
                    //    dr["SD_TIME"] = clsCommon.fcnDateExact(dr["TRX_DATE"].ToString() + (dr["SD_TIME"].ToString()).Substring(8, 6)).ToString("dd/MM/yyyy HH:mm:ss");
                    //}
                    //else
                    //{
                    //    dr["SD_TIME"] = clsCommon.fcnShortDateExact(dr["TRX_DATE"].ToString()).ToString("dd/MM/yyyy");                         
                    //}

                    //if (dr["SD_TIME"].ToString() != "")
                    //{
                    //    dr["SD_TIME"] = clsCommon.fcnDateExact(sDateTimeIncom).ToString("dd/MM/yyyy HH:mm:ss");
                    //}
                    //else
                    //{
                    //    dr["SD_TIME"] = clsCommon.fcnShortDateExact(dr["TRX_DATE"].ToString()).ToString("dd/MM/yyyy"); 
                    //}

                    // Cuongvv end

                    //Loại lệnh chuyển Nợ/Có && TKNo,TKCo
                    if ((v_strArrID.Substring(0, 2) == "PA") || (v_strArrID.Substring(0, 2) == "HP") || (v_strArrID.ToString().Substring(0, 2) == "PN"))
                    {
                        dr["LenhChuyenCo"] = clsCommon.fcnGetMessage("XBCLenhChuyenNo");
                        dr["TKNo"] = clsCommon.fcnGetMessage("XBCTKCo");
                        dr["TKCo"] = clsCommon.fcnGetMessage("XBCTKNo");
                    }
                    else //chuyển có
                    {
                        dr["LenhChuyenCo"] = clsCommon.fcnGetMessage("XBCLenhChuyenCo");
                        dr["TKNo"] = clsCommon.fcnGetMessage("XBCTKNo");
                        dr["TKCo"] = clsCommon.fcnGetMessage("XBCTKCo");
                    }
                    //Format tiền tệ
                    if (Session["gstrlanguage"].ToString() == CitadLanguage.vn)
                    {
                        dr["SoTienBangChu"] = clsCommon.fcnFormatMoneyChar(NumberToChar.NumberToChar.fcnToChar(decimal.Parse(dr["SoTien"].ToString()))) + " đồng";
                    }
                    else
                    {
                        dr["SoTienBangChu"] = clsCommon.fcnFormatMoneyChar(NumberToChar.NumberToChar.fcnToChar(decimal.Parse(dr["SoTien"].ToString()), "ENGLISH")) + " VNĐ";
                    }
                    dr["SoTien"] = clsCommon.fcnFomatAmount(dr["SoTien"]);

                    if (!v_blIsCI_HO) dr["CMND_NguoiNhan"] = "";

                    if (i_blIsOUT) // Chiều đi
                    {
                        dr["NgayGioLap_Label"] = clsCommon.fcnGetMessage("XBCNgayGioGui");

                        //Cuongvv added 20131010 GD đi: SD_TIME=Thời gian gửi;
                        if (dr["SD_TIME"].ToString() != "")
                        {
                            dr["SD_TIME"] = clsCommon.fcnDateExact(dr["TRX_DATE"].ToString() + (dr["SD_TIME"].ToString()).Substring(8, 6)).ToString("dd/MM/yyyy HH:mm:ss");
                        }
                        else
                        {
                            dr["SD_TIME"] = clsCommon.fcnShortDateExact(dr["TRX_DATE"].ToString()).ToString("dd/MM/yyyy");
                        }
                    }
                    else //Chiều đến
                    {
                        dr["NgayGioLap_Label"] = clsCommon.fcnGetMessage("XBCNgayGioNhan");

                        //Cuongvv added 20131010 GD đến: ThoiGianNhan: Thời gian nhận if ThoiGianNhan=Null then ThoiGianNhan=APPR_IN_TIME
                        dr["SD_TIME"] = dr["ThoiGianNhan"];
                        if (dr["SD_TIME"].ToString() != "")
                        {
                            dr["SD_TIME"] = clsCommon.fcnDateExact(dr["TRX_DATE"].ToString() + (dr["SD_TIME"].ToString()).Substring(8, 6)).ToString("dd/MM/yyyy HH:mm:ss");
                        }
                        else
                        {
                            dr["SD_TIME"] = dr["APPR_IN_TIME"];
                            if (dr["SD_TIME"].ToString() != "")
                            {
                                dr["SD_TIME"] = clsCommon.fcnDateExact(dr["TRX_DATE"].ToString() + (dr["SD_TIME"].ToString()).Substring(8, 6)).ToString("dd/MM/yyyy HH:mm:ss");
                            }
                            else
                            {
                                dr["SD_TIME"] = clsCommon.fcnShortDateExact(dr["TRX_DATE"].ToString()).ToString("dd/MM/yyyy");
                            }
                        }
                    }
                    if (rdbDi.Checked)
                        parV[28] = "1";
                    else if (rdbDen.Checked)
                        parV[28] = "0";

                    string strContent_Ex = dr["CONTENT_EX"].ToString();

                    if (!string.IsNullOrEmpty(strContent_Ex))
                    {
                        List<string> list = new List<string>();

                        parV[29] = clsCommon.fcnShortDateExact(ds.Tables[0].Rows[0]["TRX_DATE"].ToString()).ToString("dd/MM/yyyy");
                        parV[30] = ds.Tables[0].Rows[0]["SD_TIME"].ToString();
                        dr["MST"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "MST", ref list);
                        dr["CQT"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "CQT", ref list);
                        dr["TCQ"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "TCQ", ref list);
                        dr["LTH"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "LTH", ref list);
                        if (!string.IsNullOrEmpty(clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "NNT", ref list)))
                            dr["NNT"] = clsCommon.fcnShortDateExact(clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "NNT", ref list)).ToString("dd/MM/yyyy");

                        dr["SKH"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "SKH", ref list);
                        dr["SMA"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "SMA", ref list);
                        dr["STK"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "STK", ref list);

                        if (!string.IsNullOrEmpty(clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "NTK", ref list)))
                            dr["NTK"] = clsCommon.fcnShortDateExact(clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "NTK", ref list)).ToString("dd/MM/yyyy");
                        dr["XNK"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "XNK", ref list);
                        dr["CQP"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "CQP", ref list);
                        dr["STK"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "STK", ref list);
                        dr["TKH"] = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "", "TKH", ref list);

                        string strValue = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "VSTD", "NDG", ref list);
                        int j = 0;
                        for (int i = 0; i < list.Count; i++)
                        {
                            j=i+1;
                            dr["NDG" + j + ""] = list[i].ToString();
                            parV[43 + i] = list[i].ToString();
                        }

                        strValue = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "VSTD", "NDK", ref list);
                        for (int i = 0; i < list.Count; i++)
                        {
                            j = i + 1;
                            dr["NDK" + j + ""] = list[i].ToString();
                            parV[48 + i] = list[i].ToString();
                        }

                        strValue = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "VSTD", "MCH", ref list);
                        for (int i = 0; i < list.Count; i++)
                        {
                            j = i + 1;
                            dr["MCH" + j + ""] = list[i].ToString();
                            parV[53 + i] = list[i].ToString();
                        }

                        strValue = clsCommon.fcnGetValueXMLTag(strContent_Ex, "VST", "VSTD", "STN", ref list);
                        for (int i = 0; i < list.Count; i++)
                        {
                            j = i + 1;
                            dr["STN" + j + ""] = clsCommon.fcnFomatAmount(list[i].ToString());
                            parV[58 + i] = clsCommon.fcnFomatAmount(list[i].ToString());
                        }
                    }
                }

                
                for (int i = 0; i < parV.Length; i++)
                {
                    if (parV[i] == null) parV[i] = "";
                }

                ds.Tables[0].AcceptChanges();
                Session["Data"] = ds;
                Session["TenBaoCao"] = "rptInGiayBao.rpt";
                Session["TenPara"] = par;
                Session["GiaTriPara"] = parV;
                Session["BACKURL"] = Request.Url.AbsoluteUri;
                Response.Redirect("~/Modules/ViewReport/XemBaoCao.aspx");
            }
            catch (Exception ex)
            {
                clsCommon.fcnWriteLogFileBankCode("InGiayBao.fcnPrint", ex.Message);
                throw ex;
            }
        }

        #endregion

        #region "FORM LOAD"

        /// <summary>
        /// Sự kiện load form
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Page_Load(object sender, EventArgs e)
        {
            MessageBox1.ScriptManager1 = this.ScriptManager1;
            if (!Page.IsPostBack)
            {
                grvInGiayBao.PageSize = clsCommon.fcnGetGRID_SIZE();
                Menu1.Items[1].Enabled = false;
                Menu1.Items[2].Enabled = false;
                dtpNgayGD.Text = Application["gstrCI_Date"].ToString().Substring(6, 2) + "/" + Application["gstrCI_Date"].ToString().Substring(4, 2) + "/" + Application["gstrCI_Date"].ToString().Substring(0, 4);
                fncQuery(0);
                dtpNgayGD.Focus();
            }
        }

        /// <summary>
        /// Sự kiện trước khi load trang web
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void Page_PreLoad(object sender, EventArgs e)
        {
            try
            {
                int v_intMENU_ID = (int)CitadMenuID.InGiayBao;

                string v_strARR_MENU_ID = "," + clsCommon.fcnGetMenuAccess((string)Session["gstrLoginID"]) + ",";

                if (!v_strARR_MENU_ID.Contains("," + v_intMENU_ID + ","))
                {
                    Response.Redirect("~/Default.aspx");
                }
            }
            catch (Exception ex)
            {
                Response.Redirect("~/Default.aspx");
            }
        }

        #endregion

        #region "Form event"

        protected void grvInGiayBao_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grvInGiayBao.PageIndex = e.NewPageIndex;
            fncQuery(e.NewPageIndex);
        }

        protected void grvInGiayBao_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Attributes.Add("msg_key", DataBinder.Eval(e.Row.DataItem, "MSG_KEY").ToString());
                e.Row.Attributes.Add("onmouseover", "row_ChangeBackColor(this,true);");
                e.Row.Attributes.Add("onmouseout", "row_ChangeBackColor(this,false);");
                //e.Row.Attributes.Add("ondblclick", "row_ondblclick(this);");width="765px"
            }
        }

        //protected void ckbSoHieuGD_CheckedChanged(object sender, EventArgs e)
        //{
        //    if (ckbSoHieuGD.Checked == true)
        //    {
        //        txtSoHieuGD.Enabled = true;
        //        txtSoHieuGD.Text = "";
        //    }
        //    else
        //    {
        //        txtSoHieuGD.Text = "";
        //        txtSoHieuGD.Enabled = false;
        //    }
        //}

        //protected void ckbSoButtoan_CheckedChanged(object sender, EventArgs e)
        //{
        //    if (ckbSoButtoan.Checked == true)
        //    {
        //        txtSoButtoan.Enabled = true;
        //        txtSoButtoan.Text = "";
        //    }
        //    else
        //    {
        //        txtSoButtoan.Text = "";
        //        txtSoButtoan.Enabled = false;
        //    }
        //}

        protected void Menu1_MenuItemClick(object sender, MenuEventArgs e)
        {
            switch (e.Item.Value.ToString())
            {
                case "mnuClose":
                    Response.Redirect("~/Default.aspx", false);
                    break;
                case "mnuPrint":
                    fcnPrint(true);
                    break;
                case "mnuReprint":
                    fcnPrint(false);
                    break;
                case "mnuIquiry":
                    fncQuery(0);
                    break;
            }
        }

        protected void rdbDi_CheckedChanged(object sender, EventArgs e)
        {
            //if (rdbDi.Checked) lblOR_CI_ID.Text = clsCommon.fcnGetMessage("R_CI_TEXT");
            //else if (rdbDen.Checked) lblOR_CI_ID.Text = clsCommon.fcnGetMessage("O_CI_TEXT");
            fcnUpdateUI();
        }

        protected void rdbDen_CheckedChanged(object sender, EventArgs e)
        {
            //if (rdbDi.Checked) lblOR_CI_ID.Text = clsCommon.fcnGetMessage("R_CI_TEXT");
            //else if (rdbDen.Checked) lblOR_CI_ID.Text = clsCommon.fcnGetMessage("O_CI_TEXT");
            fcnUpdateUI();
        }

        protected void rdbNoPrint_CheckedChanged(object sender, EventArgs e)
        {
            fcnUpdateUI();
        }

        protected void rdbPrinted_CheckedChanged(object sender, EventArgs e)
        {
            fcnUpdateUI();
        }

        protected void dtpNgayGD_TextChanged(object sender, EventArgs e)
        {
            fcnUpdateUI();
        }

        private void fcnUpdateUI()
        {
            Menu1.Items[1].Enabled = false;
            Menu1.Items[2].Enabled = false;
        }

        #endregion

        #region "Nhóm hàm xử lý ngôn ngữ cho trang web - tất cả các module giống nhau"

        protected override void InitializeCulture()
        {
            try
            {
                if (Session["gstrLanguage"] != null)
                {
                    string strCi = (string)Session["gstrLanguage"];
                    System.Globalization.CultureInfo ci = new System.Globalization.CultureInfo(strCi);
                    System.Threading.Thread.CurrentThread.CurrentCulture = ci;
                    System.Threading.Thread.CurrentThread.CurrentUICulture = ci;
                }
                base.InitializeCulture();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }

        #endregion

        #region "Sort GridView"

        protected void grvInGiayBao_Sorting(object sender, GridViewSortEventArgs e)
        {
            if (e.SortExpression == (string)ViewState["_SortExpression"])
            {
                if ((SortDirection)ViewState["_SortDirection"] == SortDirection.Ascending)
                {
                    e.SortDirection = SortDirection.Descending;
                }
            }

            ViewState["_ConvertToNumber"] = false;
            if (e.SortExpression == "AMOUNT")
            {
                ViewState["_ConvertToNumber"] = true;
            }
            ViewState["_SortDirection"] = e.SortDirection;
            ViewState["_SortExpression"] = e.SortExpression;

            fncQuery(grvInGiayBao.PageIndex);
        }

        #endregion
    }
}