﻿--
prompt PL/SQL Developer import file
prompt Created on 28 04, 2014 by Vu Van Cuong
set feedback off
set define off

prompt alter table TBLTRANSACTIONMSG_ORG add CONTENT_EX...
alter table TBLTRANSACTIONMSG_ORG add CONTENT_EX VARCHAR2(3000 CHAR);

prompt Dropping TBLTRANSACTIONMSG_ORG_PK_1...
alter table TBLTRANSACTIONMSG_ORG  drop constraint TBLTRANSACTIONMSG_ORG_PK_1 cascade;

prompt Dropping TBLTRANSACTIONMSG_ORG_PK_2...
alter table TBLTRANSACTIONMSG_ORG  drop constraint TBLTRANSACTIONMSG_ORG_PK_2 cascade;

prompt alter table TBLTRANSACTIONMSG_ORG add constraint TBLTRANSACTIONMSG_ORG_PK_1...
alter table TBLTRANSACTIONMSG_ORG add constraint TBLTRANSACTIONMSG_ORG_PK_1 unique (TRX_DATE, O_CI_ID, RELATION_NO) deferrable novalidate;

prompt alter table TBLTRANSACTIONMSG_ORG add constraint TBLTRANSACTIONMSG_ORG_PK_2...
alter table TBLTRANSACTIONMSG_ORG  add constraint TBLTRANSACTIONMSG_ORG_PK_2 unique (TRX_DATE, O_CI_ID, SERIAL_NO, TRX_TYPE) deferrable novalidate ;

prompt drop index TBLTRANSACTIONMSG_ORG_IDX...
drop index TBLTRANSACTIONMSG_ORG_IDX ;
drop index TBLTRANSACTIONMSG_ORG_IDX_1 ;

prompt create index TBLTRANSACTIONMSG_ORG_IDX...
create index TBLTRANSACTIONMSG_ORG_IDX on TBLTRANSACTIONMSG_ORG (TRX_DATE, O_CI_ID, SERIAL_NO);
prompt create index TBLTRANSACTIONMSG_ORG_IDX_1...
create index TBLTRANSACTIONMSG_ORG_IDX_1 on TBLTRANSACTIONMSG_ORG (TRX_DATE, R_CI_ID,GTW_FLAG,Response_code,TRX_STATUS,Process);


prompt Creating TBLMESSAGE_QUEUE_BK...
create table tblmessage_queue_2014 as select * from tblmessage_queue;
prompt Truncating TBLMESSAGE_QUEUE...
Truncate table TBLMESSAGE_QUEUE;
prompt  Create/Recreate primary, unique and foreign key constraints... 
declare
 strSQL VARCHAR2(4000):='';
 sTableName varchar2(100):= '';
 i_count    integer;         
begin 
  select count(1) into i_count  from user_constraints t where constraint_name='TBLMESSAGE_QUEUE_PK';
  if i_count > 0 then
    select table_name into sTableName from user_constraints t where constraint_name='TBLMESSAGE_QUEUE_PK';  
    strSQL := 'alter table ' || sTableName || ' drop constraint TBLMESSAGE_QUEUE_PK cascade';
    EXECUTE IMMEDIATE strSQL; 
  end if;
  strSQL := 'alter table TBLMESSAGE_QUEUE  add constraint TBLMESSAGE_QUEUE_PK primary key (MSG_KEY, TRX_TYPE)';
  EXECUTE IMMEDIATE strSQL;
end;
/
prompt drop index TBLMESSAGE_QUEUE_IDX...
drop index TBLMESSAGE_QUEUE_IDX;

prompt drop index TBLMESSAGE_QUEUE_IDX_1...
drop index TBLMESSAGE_QUEUE_IDX_1;

prompt create index TBLMESSAGE_QUEUE_IDX ...
create index TBLMESSAGE_QUEUE_IDX on TBLMESSAGE_QUEUE (TRX_DATE, SERIAL_NO, TRX_TYPE);

prompt create index TBLMESSAGE_QUEUE_IDX_1 ...
create index TBLMESSAGE_QUEUE_IDX_1 on TBLMESSAGE_QUEUE (TRX_DATE, SERIAL_NO, TRX_TYPE, PROCESS, RESPONSE_CODE);

prompt 
prompt Dropping TBLGENKEY_NEW...
Drop table TBLGENKEY_NEW cascade constraints;
prompt Creating TBLGENKEY_NEW...
create table TBLGENKEY_NEW(SERV_CODE  VARCHAR2(2) not null,CURRENTKEY NUMBER(8) not null,CURRENYEAR VARCHAR2(2 CHAR) not null);
alter table TBLGENKEY_NEW  add constraint TBLGENKEY_NEW_PK primary key (SERV_CODE, CURRENTKEY, CURRENYEAR);

prompt insert into TBLGENKEY_NEW HF...
insert into TBLGENKEY_NEW (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('HF',(select DECODE(MAX(substr(t.msg_key,5,8)),null,1 ,MAX(substr(t.msg_key,5,8))) from tbltransactionmsg_org t where t.trx_date like (select substr(VALUE,1,4)|| '%' from tblenv_control where type='GLOBAL_DATE') and t.r_ci_id =(select VALUE from tblenv_control where type='BANK_ID') and t.msg_key like 'HFI%'),(select substr(VALUE,3,2) from tblenv_control where type='GLOBAL_DATE'));
prompt insert into TBLGENKEY_NEW HP...
insert into TBLGENKEY_NEW (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('HP',(select DECODE(MAX(substr(t.msg_key,5,8)),null,1 ,MAX(substr(t.msg_key,5,8))) from tbltransactionmsg_org t where t.trx_date like (select substr(VALUE,1,4)|| '%' from tblenv_control where type='GLOBAL_DATE') and t.r_ci_id =(select VALUE from tblenv_control where type='BANK_ID') and t.msg_key like 'HPI%'),(select substr(VALUE,3,2) from tblenv_control where type='GLOBAL_DATE'));
prompt insert into TBLGENKEY_NEW HR...
insert into TBLGENKEY_NEW (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('HR',(select DECODE(MAX(substr(t.msg_key,5,8)),null,1 ,MAX(substr(t.msg_key,5,8))) from tblfund_return t where t.trx_date like (select substr(VALUE,1,4)|| '%' from tblenv_control where type='GLOBAL_DATE') and t.r_ci_id =(select VALUE from tblenv_control where type='BANK_ID') and t.msg_key like 'HRI%'),(select substr(VALUE,3,2) from tblenv_control where type='GLOBAL_DATE'));
prompt insert into TBLGENKEY_NEW LR...
insert into TBLGENKEY_NEW (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('LR',(select DECODE(MAX(substr(t.msg_key,5,8)),null,1 ,MAX(substr(t.msg_key,5,8))) from tblfund_return t where t.trx_date like (select substr(VALUE,1,4)|| '%' from tblenv_control where type='GLOBAL_DATE') and t.r_ci_id =(select VALUE from tblenv_control where type='BANK_ID') and t.msg_key like 'LRI%'),(select substr(VALUE,3,2) from tblenv_control where type='GLOBAL_DATE'));
prompt insert into TBLGENKEY_NEW LF...
insert into TBLGENKEY_NEW (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('LF',(select DECODE(MAX(substr(t.msg_key,5,8)),null,1 ,MAX(substr(t.msg_key,5,8))) from tbltransactionmsg_org t where t.trx_date like (select substr(VALUE,1,4)|| '%' from tblenv_control where type='GLOBAL_DATE') and t.r_ci_id =(select VALUE from tblenv_control where type='BANK_ID') and t.msg_key like 'LFI%'),(select substr(VALUE,3,2) from tblenv_control where type='GLOBAL_DATE'));
prompt commit...
commit;

prompt Dropping TBLVST_CQT...
drop table TBLVST_CQT cascade constraints;
prompt Creating TBLVST_CQT...
create table TBLVST_CQT
(
  CQT_ID   NUMBER(8) not null,
  MA_CQTHU VARCHAR2(7) not null,
  NAME_V   VARCHAR2(200 CHAR) not null,
  NAME_E   VARCHAR2(200),
  USED     VARCHAR2(1)  
);
alter table TBLVST_CQT add constraint TBLVST_CQT_PK primary key (CQT_ID);
alter table TBLVST_CQT add constraint TBLVST_CQT_FK unique (MA_CQTHU, NAME_V);

prompt Dropping TBLVST_MCH...
drop table TBLVST_MCH cascade constraints;
prompt Creating TBLVST_MCH ...
create table TBLVST_MCH
(
  MA_CHUONG VARCHAR2(3) not null,
  NAME_V     VARCHAR2(200 CHAR),
  NAME_E     VARCHAR2(200),
  MA_CAP    VARCHAR2(10),
  USED    VARCHAR2(1)
);
alter table TBLVST_MCH add constraint TBLVST_MCH_PK primary key (MA_CHUONG);

prompt Dropping TBLVST_NDK...
drop table TBLVST_NDK cascade constraints;
prompt Creating TBLVST_NDK ...
create table TBLVST_NDK
(
  MA_NDKT VARCHAR2(4) not null,
  NAME_V   VARCHAR2(200 CHAR),
  NAME_E   VARCHAR2(200),
  MA_CHA  VARCHAR2(10),
  USED    VARCHAR2(1)
);
alter table TBLVST_NDK add constraint TBLVST_NDK_PK primary key (MA_NDKT);

prompt Dropping TBLVST_XNK...
drop table TBLVST_XNK cascade constraints;
prompt Creating TBLVST_XNK ...
create table TBLVST_XNK
(
  MA_LH  VARCHAR2(20) not null,
  NAME_V  VARCHAR2(200 CHAR),
  NAME_E  VARCHAR2(200),
  TEN_VT VARCHAR2(50),
  USED    VARCHAR2(1)
);
alter table TBLVST_XNK add constraint TBLVST_XNK_PK primary key (MA_LH);

prompt Dropping TBLVST_TAX...
drop table TBLVST_TAX cascade constraints;
prompt Creating TBLVST_TAX ...
create table TBLVST_TAX
(
  CODE   VARCHAR2(2) not null,
  NAME_V   VARCHAR2(200 CHAR),
  NAME_E VARCHAR2(200),
  USED    VARCHAR2(1)
);
alter table TBLVST_TAX add constraint TBLVST_TAX_PK primary key (CODE);
insert into TBLVST_TAX (CODE, NAME_V, NAME_E, USED) values ('01', 'Thuế nội địa', null, 'U');
insert into TBLVST_TAX (CODE, NAME_V, NAME_E, USED) values ('02', 'Thuế thu nhập cá nhân', null, 'U');
insert into TBLVST_TAX (CODE, NAME_V, NAME_E, USED) values ('03', 'Thuế chước bạ', null, 'U');
insert into TBLVST_TAX (CODE, NAME_V, NAME_E, USED) values ('04', 'Thuế hải quan', null, 'U');
insert into TBLVST_TAX (CODE, NAME_V, NAME_E, USED) values ('05', 'Thu khác', null, 'U');
insert into TBLVST_TAX (CODE, NAME_V, NAME_E, USED) values ('06', 'Thu tài chính', null, 'U');
insert into TBLVST_TAX (CODE, NAME_V, NAME_E, USED) values ('07', 'Phạt vi phạm hành chính', null, 'U');
commit;

prompt Dropping TBLVST_ADD...
drop table TBLVST_ADD cascade constraints;
prompt Creating TBLVST_ADD ...
create table TBLVST_ADD
(
  MSG_KEY       VARCHAR2(12) not null,
  MSG_TYPE      VARCHAR2(4),
  TRX_TYPE      VARCHAR2(6),
  ERR_STATUS    VARCHAR2(4),
  TRX_DATE      VARCHAR2(8) not null,
  SD_TIME       VARCHAR2(14),
  O_CI_ID       NUMBER(8) not null,
  RESPONSE_CODE VARCHAR2(4),
  SERIAL_NO     VARCHAR2(8) not null,
  CREATE_TIME   VARCHAR2(14),
  APPR_ID       VARCHAR2(16),
  APPR_TIME     VARCHAR2(14),
  TRX_TYPE_ORG  VARCHAR2(6) not null,
  R_CI_ID       NUMBER(8),
  CONTENT_EX    VARCHAR2(3000 CHAR),
  TRX_FILE_NAME VARCHAR2(25),
  GTW_FLAG      CHAR(1),
  BALANCE_TIME  VARCHAR2(14),
  MAC           VARCHAR2(28)
);
alter table TBLVST_ADD  add constraint TBLVST_ADD_PK primary key (MSG_KEY);
alter table TBLVST_ADD  add constraint TBLVST_ADD_FK unique (O_CI_ID, SERIAL_NO, TRX_DATE, TRX_TYPE_ORG);

alter table TBLTRANSACTIONMESSAGEFORMAT drop column HV ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column LV ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column HL ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column RQ ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column RH ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column RK ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column RX ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column TBLVST_ADD ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column TBLVST_CQT ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column TBLVST_MCH ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column TBLVST_NDK ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column TBLVST_XNK ;
alter table TBLTRANSACTIONMESSAGEFORMAT drop column TBLVST_TAX ;

alter table TBLTRANSACTIONMESSAGEFORMAT add HV NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add LV NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add HL NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add RQ NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add RH NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add RK NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add RX NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add TBLVST_ADD NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add TBLVST_CQT NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add TBLVST_MCH NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add TBLVST_NDK NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add TBLVST_XNK NUMBER(8);
alter table TBLTRANSACTIONMESSAGEFORMAT add TBLVST_TAX NUMBER(8);

Update TBLTRX_TYPE set COMMENTS = '20141101' where ID = 901; 
commit;
set feedback on
set define on
prompt Done.