package sbv.messages.securities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;

import java.security.MessageDigest;

import java.security.NoSuchAlgorithmException;

import java.security.PrivateKey;
import java.security.PublicKey;

import java.security.SecureRandom;

import java.text.SimpleDateFormat;

import java.util.Arrays;

import java.util.Calendar;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCrypto {
    private static final String ALGORITHM_ENCRYPT = "SHA-256";
    private static SecretKeySpec secretKey;
    private static byte[] key;
 
    /**
     * Ham lay chuoi khoa ky de ma hoa doi xung 
     * */
    private static SecretKeySpec getSecretKeySpec(String key) throws NoSuchAlgorithmException,
                                                                    UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(key.getBytes("UTF-8"));
        byte[] keyBytes = new byte[16];
        System.arraycopy(digest.digest(), 0, keyBytes, 0, keyBytes.length);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        return secretKeySpec;        
    }
    
    /**
     * Ham ma hoa bat doi xung chuoi khoa ky
     * Don vi gui tin dung PublicKey cua doi tac de ma hoa
     * */
    private static byte[] encrypt(byte[] bSource, 
                                  PublicKey publicKey) throws Exception {
        byte[] bEncrypt = null;
        try {
            //1.Khoi tao Instace RSA
            Cipher encryptCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            encryptCipher.init(Cipher.ENCRYPT_MODE, publicKey );
            //2.Ma hoa
            bEncrypt = encryptCipher.doFinal(bSource);           
        }catch (Exception ex) {
            System.out.println("[" + getCurrentDateTimeNow() +
                               "][encrypt_Key][" + ex.getMessage() + "]");
        }
        return bEncrypt;
     }
        
    /**
     * Ham giai ma bat doi xung chuoi ma hoa thanh khoa ky
     * Don vi nhan tin dung PrivateKey cua minh de giai ma
     * */
     private static byte[] decrypt(byte[] bSource, 
                                   PrivateKey privateKey) throws Exception {
               
            byte[]  bDecrypt = null;
            
            try {
                //1.Khoi tao Instace RSA
                Cipher decriptCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                decriptCipher.init(Cipher.PRIVATE_KEY, privateKey);
                //2.Giai ma
                bDecrypt = decriptCipher.doFinal(bSource);
            }catch (Exception ex) {
                System.out.println("[" + getCurrentDateTimeNow() +
                                   "][decrypt_Key][" + ex.getMessage() + "]");
            }
            return bDecrypt;
        }
        
        private static String getCurrentDateTimeNow() {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(cal.getTime());
        }
        
        
        public static String encrypt_AES_RSA(Object objSource, 
                                         String key, 
                                         PrivateKey privateKey,
                                         PublicKey publicKey) {
            byte[] bSource = null;
            String base64Return = null;
    
            try {
                bSource = objSource.toString().getBytes("UTF-8");
                //1.Generating Initialization vector (IV)
                int ivSize = 16;
                byte[] iv = new byte[ivSize];
                SecureRandom random = new SecureRandom();
                random.nextBytes(iv);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                
                //2. Get SecretKey
                SecretKeySpec secretKeySpec = getSecretKeySpec(key);
        
                //3.Encrypt bSource
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec, ivParameterSpec);
                byte[] enSource = cipher.doFinal(bSource);
        
                //4.Combine ivParameterSpec and enSource encrypted
                byte[] comIVandEnSource = new byte[ivSize + enSource.length];
                System.arraycopy(iv, 0, comIVandEnSource, 0, ivSize);
                System.arraycopy(enSource, 0, comIVandEnSource, ivSize, enSource.length);
                
                //5.Encrypt SecretKey with PublicKey 
                byte[] enSecretKey = encrypt(secretKeySpec.getEncoded(),publicKey);
                
                //6. Combine enSecretKey and comIVandEnSource
                byte[] comReturn = new byte[enSecretKey.length + comIVandEnSource.length];
                System.arraycopy(enSecretKey, 0, comReturn, 0, enSecretKey.length);
                System.arraycopy(comIVandEnSource, 0, comReturn, enSecretKey.length, comIVandEnSource.length);
                
                //7. Convert Byte Array to Base64
                base64Return = Base64.base64Encode(comReturn);
                }catch (Exception ex) {
                    System.out.println("[" + getCurrentDateTimeNow() +
                                       "][encrypt_Msg][" + ex.getMessage() + "]");
                }                   
            return base64Return;
        }

         
        public static String decrypt_AES_RSA(Object objSource, 
                                         PrivateKey privateKey,
                                         PublicKey publicKey) {
           int ivSize = 16;
           int keyLength = 0;
           byte[] bSource = null;
           String deReturn = null;
           try {
               //1. Get KeyLength of PublicKey
               keyLength = CertUtils.getKeyLength(publicKey)/8;
               
               //2. Decode to Base64 to Byte Array
               bSource = Base64.base64Decode(objSource.toString());
               
               //3. Extract Encrypt SecretKey
               byte[] enSecretKey = new byte[keyLength];
               System.arraycopy(bSource, 0, enSecretKey, 0, keyLength);
               
               //4. Extract IV
               byte[] iv = new byte[ivSize];
               System.arraycopy(bSource, keyLength , iv, 0, iv.length);
               IvParameterSpec ivParameterSpec = new IvParameterSpec(iv); 
               
               //5. Extract encrypted part
               int encryptedSize = bSource.length - ivSize-keyLength;
               byte[] encryptedBytes = new byte[encryptedSize];
               System.arraycopy(bSource, keyLength + ivSize, encryptedBytes, 0, encryptedSize);
               
               //6. Get SecretKey
               byte[] decryptedKey = decrypt(enSecretKey, privateKey);
               SecretKeySpec originalKey = new SecretKeySpec(decryptedKey, 0, decryptedKey.length, "AES");
               
               //7. Decrypt
               Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
               cipherDecrypt.init(Cipher.DECRYPT_MODE, originalKey, ivParameterSpec);
               byte[] decrypted = cipherDecrypt.doFinal(encryptedBytes);
               deReturn = new String(decrypted, "UTF-8");
               }catch (Exception ex) {
                   System.out.println("[" + getCurrentDateTimeNow() +
                                      "][decrypt_Msg][" + ex.getMessage() + "]");
               }  
           return deReturn;
       }
}
