package sbv.messages.securities;

import java.security.PublicKey;
import java.security.Signature;

import java.text.SimpleDateFormat;

import java.util.Calendar;

public class VerifyMsg {
    private static final String ALGORITHM = "SHA256withRSA";
    public static boolean verifyMsg(String sSource,
                             PublicKey publicKey,
                             String sSign) {
        byte[] bSign = null;
        byte[] bSource = null;
        byte[] bSourceSHA256 = null;
        boolean bVerify = false;
        try {
            //1.Lay ma nhi phan voi ma UTF-8 chuoi vao sSource
            bSource = sSource.getBytes("UTF-8");
            //2.Bam chuoi nhi phan voi thuat toan SHA256
            bSourceSHA256 = HashAlgorithm.SHA256(bSource);
            //3.Chuyen doi chu ky so sSign dang Base64 sang dang nhi phan
            bSign = Base64.base64Decode(sSign);
            //4.Xac thuc
            bVerify = verifing(bSourceSHA256, publicKey, bSign);
        } catch (Exception ex) {
            System.out.println("[" + getCurrentDateTimeNow() +
                               "][verifyMSg][" + ex.getMessage() + "]");
        }
        return bVerify;
    }
    
    private static boolean verifing(byte[] bSource, PublicKey publicKey,
                                    byte[] bSign) {
        Boolean bverify = null;
        try {
            Signature sha1_rsa =
                Signature.getInstance(ALGORITHM);
            sha1_rsa.initVerify(publicKey);
            sha1_rsa.update(bSource);
            bverify = sha1_rsa.verify(bSign);
        } catch (Exception ex) {
            System.out.println("[" + getCurrentDateTimeNow() +
                               "][verifing][" + ex.getMessage() + "]");
        }
        return bverify;
    }
    
    private static String getCurrentDateTimeNow() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }
}
