using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using CITAD.Data;
using CITAD.Core.Domain;
using CITAD.Common;
using System.Collections.Generic;
using System.Globalization;
using System.Text;
using System.Collections.ObjectModel;

namespace CITAD.Web.Modules.DanhSachFileTuTrungTam
{
    public partial class DanhSachFileTuTrungTam : System.Web.UI.Page
    {

        #region "CONST"

        const int MENUITEM_APPROVE = 2;//Vị trí nút duyệt trên menu
        const int COL_ESIGN_MESSAGE = 8;//Vị trí cột chứa nội dung tạo chữ ký
        const int COL_ESIGN_CONTENT = 9;//Vị trí cột chứa chữ ký

        #endregion

        #region "Private function"
        private string C_FILE = "File select";    
        private bool USE_ESIGN = false;

        int m_intGridIndexFile = 0;
        int m_intGridIndexRequest = 0;
        
        protected string formatTime(string str)
        {
            if (Int16.Parse(str)<10) {return "0"+str  ;}
            else {return str;}

        }
        private void SaveRserveDic()
        {
            int intID = 1;

            TBLFILE_REQUESTModule mdlTBLFILE_RSERVE = new TBLFILE_REQUESTModule();
            TBLFILE_REQUEST objTBLFILE_RSERVE = new TBLFILE_REQUEST();
            List<TBLFILE_REQUEST> arr = mdlTBLFILE_RSERVE.GetByQueryString("FROM TBLFILE_REQUEST ORDER BY CREATE_TIME DESC");
            //if (arr.Count > 1) intID = arr[0].ID + 1;
            //objTBLFILE_RSERVE.ID = intID;
            objTBLFILE_RSERVE.TRX_FILE_NAME = "Dữ liệu từ điển";
            //chú ý rằng tên bản ghi dữ liệu từ điển sẽ không tự in ra được
            if (Session[""] == null) { return; }
            objTBLFILE_RSERVE.USER_ID = (string)Session[""];
            if (false)
            {
               // return;
            }
            objTBLFILE_RSERVE.ESIGN = "";
            objTBLFILE_RSERVE.CREATE_TIME = GetDateNow();
            mdlTBLFILE_RSERVE.Save(objTBLFILE_RSERVE);
           

        }

        private void subGetListType()
        {
            string sqlFileType = "SELECT   FILE_TYPE, FILE_NAME + '-' + DESCRIPTION_V AS FILE_TYPE_V, FILE_NAME+ '-' +DESCRIPTION_E AS FILE_TYPE_E   ";
           sqlFileType+= " FROM  TBLFILE_INFO GROUP BY FILE_TYPE, FILE_NAME, DESCRIPTION_V, DESCRIPTION_E";
            clsDAL clsD = new clsDAL();
            DataSet dsFile = new DataSet();
            dsFile = clsD.fcnExecQuery(sqlFileType);
            cbo_File_Type.DataSource = dsFile;
            

            cbo_File_Type.DataValueField="FILE_TYPE";
            if (Session["gstrLanguage"].ToString() == CitadLanguage.vn)
            {
                cbo_File_Type.DataTextField = "FILE_TYPE_V";
            }
            else
            {
                cbo_File_Type.DataTextField = "FILE_TYPE_E";
            }
            cbo_File_Type.DataBind();
            cbo_File_Type.Items.Insert(0,new ListItem(clsCommon.fcnGetMessage("STMSG15"), "15"));
        }       

        private void subGetListFile(int i_intPageIndex)
        {
            string strbytFileList = "SELECT TRX_FILE_NAME, FILE_TYPE,DESCRIPTION_V,DESCRIPTION_E,FILE_SIZE,FILE_STATUS,TRX_DATE ";
            string strSearch;
            clsDAL clsD = new clsDAL();
            DataSet ds = new DataSet();

            //Kiem tra xem co so du lieu la sqlServer Hay oracle.
            if (clsD.DataBaseType == eDataBaseType.ORACLE)
            {
                strbytFileList = strbytFileList + " FROM TBLFILE_LIST ,tblFile_info  WHERE  substr(trx_file_name,0,7)=file_name ";
            }
            else
            {
                strbytFileList = strbytFileList + " FROM TBLFILE_LIST ,tblFile_info  WHERE  substring(trx_file_name,0,7)=file_name ";
            }

            if (txtFileName.Text != "")
            {
                strSearch = txtFileName.Text;
                strbytFileList += " AND  TRX_FILE_NAME LIKE '%" + strSearch + "%'";
            }
            if (cbo_File_Type.SelectedItem.Value != "15")
            {
                strSearch = cbo_File_Type.SelectedItem.Value;
                strbytFileList += " AND FILE_TYPE = '" + strSearch + "'";
            }
            if (dtpTRX_Date.Text != "")
            {
                strSearch = dtpTRX_Date.Text.Trim();
                string strSearch1 = strSearch;
                strSearch = strSearch.Replace("/", "");
                string strD = strSearch.Substring(0, 2);
                string strM = strSearch.Substring(2, 2);
                string strY = strSearch.Substring(4, 4);


                strSearch = strY + strM + strD;
                strbytFileList += " AND TRX_DATE like '" + strSearch + "%'";
            }
            if (cboCI_Status.SelectedItem.Value != "04")
            {
                strSearch = cboCI_Status.SelectedItem.Value;
                strbytFileList += " AND FILE_STATUS = '" + strSearch + "'";
            }
            strbytFileList += " GROUP BY TRX_FILE_NAME, FILE_TYPE,DESCRIPTION_V,DESCRIPTION_E, FILE_SIZE, FILE_STATUS, TRX_DATE ORDER BY TRX_DATE DESC ";

            ds = clsD.fcnExecQuery(strbytFileList);
            string gridSize = clsCommon.fcnGetENVControl("GRID_SIZE");

            if (gridSize == "")
                grvCIList.PageSize = 10;
            else
                grvCIList.PageSize = int.Parse(gridSize);

            grvCIList.DataSource = ds.Tables[0];
            lblCount.Text = ds.Tables[0].Rows.Count.ToString();

            grvCIList.PageIndex = i_intPageIndex;
            grvCIList.DataBind();
            ScriptManager1.SetFocus(txtFileName);
            //=========================================================
            //Thêm dữ liệu ký
            fcnInitESIGN_MESSAGE();
        }       

        //private void subSaveRequest()
        //{
        //    int  intSave = 0;
        //    string strUserName = "gstrLoginName";
        //    //==========================================================
        //    //Lấy serial người ký duyệt
        //    string v_strSERIAL_NUMBER = "";
        //    if (USE_ESIGN)
        //    {
        //        v_strSERIAL_NUMBER = clsCommon.fcnGetUSER_CERT(Session["gstrLoginID"].ToString(), Application["gstrCI_ID"].ToString()).ID;
        //    }
        //    //==========================================================
            
            
        //    foreach (GridViewRow row in grvCIList.Rows)
        //    {
        //        if (((HtmlInputCheckBox)row.FindControl("chkMore")).Checked)
        //        {
        //            //===========================================================
        //            //Lấy chữ ký ở cột hidESIGN_CONTENT
        //            string v_strESIGN = ((HiddenField)row.FindControl("hidESIGN_CONTENT")).Value;
        //            v_strESIGN += Application["gstrCI_Date"].ToString() + DateTime.Now.ToString("HHmmss") + v_strSERIAL_NUMBER;
        //            //===========================================================
        //            int intID = 0;
        //            string strTRC_FILE_NAME = "";
        //            string strTRX_TYPE = "";
        //            //string strTAD_ID = Application["gstrtTAD_Code"];
        //            //TBLFILE_REQUESTModule mdlTBLFILE_REQUEST = new TBLFILE_REQUESTModule();
        //            //TBLFILE_REQUEST objTBLFILE_REQUEST = new TBLFILE_REQUEST();
        //            //TBLFILE_INFOModule mdlTBLFILE_REQUEST = new TBLFILE_INFOModule();
        //            //TBLFILE_REQUESTModule mdlTBLFILE_REQUEST = new TBLFILE_REQUESTModule();
        //            //TBLFILE_INFO objTBLFILE_INFO = mdlTBLFILE_REQUEST.GetById("strTRC_FILE_NAME");
        //            if (objTBLFILE_INFO != null)
        //            {
        //                strTRX_TYPE = objTBLFILE_INFO.TRX_TYPE;
        //            }
        //            else 
        //            {
        //                break ;
        //            }

        //            objTBLFILE_REQUEST.ID = clsCommon.fcnMakeMessage(strTRX_TYPE, "");                   
        //            strTRC_FILE_NAME=grvCIList.DataKeys[row.RowIndex]["TRX_FILE_NAME"].ToString();
        //            objTBLFILE_REQUEST.TRX_FILE_NAME = strTRC_FILE_NAME;
        //            if (Session[strUserName] == null) { return; }                    
        //            objTBLFILE_REQUEST.USER_ID = (string)Session[strUserName];
        //            objTBLFILE_REQUEST.ESIGN = v_strESIGN;
        //            objTBLFILE_REQUEST.CREATE_TIME = GetDateNow();                                        
        //            mdlTBLFILE_REQUEST.Save(objTBLFILE_REQUEST);
        //            mdlTBLFILE_REQUEST.Commit();
        //            //getSaveMess(strTRC_FILE_NAME);
        //            intSave += 1;
        //        }

        //    }
        //    if (intSave>0)
        //    {
        //        // dua ra thong bao da nhan duoc intSave
        //        //MessageBox1.Show("GLMSG03: " + clsCommon.fcnGetMessage("GLMSG03"), MessageBoxType.Warning);
        //        //Response.Redirect("FileListRequest.aspx");
        //        //TabContainer1.ActiveTabIndex = 1;
        //    }else { 
        //        //dua ra thong bao  khong chuyen duoc file nao ca
        //       // MessageBox1.Show("GLMSG03: " + clsCommon.fcnGetMessage("GLMSG03"), MessageBoxType.Warning);
        //    }


        //}

        private string getMessageSign(string strFileName)
        {
            string strSign = "";
            string v_strStatusCode = "";
            string v_strSendtime = "";
            string v_strRescode = "";
            string v_strRespone = "";
            //lay 4 gia system_type 
            strSign += "" + clsCommon.fcnGetENVControl("SYS_TYPE_FTL").PadRight(4, ' ');
                                                                                                                                                
            //lay 4 gia tri msg_type_ftl
            strSign += "" + clsCommon.fcnGetENVControl("MSG_TYPE_FTL").PadRight(4, ' ');
            //lay gia tri TR_TYPE
            if (chkSync.Checked)
            {
                strSign += "909092";
            }
            else { strSign += "510670"; }
           
            //Gia tri status code
            strSign += "" + v_strStatusCode.PadRight(4, ' ');
            // giá trị tr_date
            strSign += "" + clsCommon.fcnGetENVControl("GLOBAL_DATE").PadRight(8, ' ');
            //sendtime
            strSign += "" + v_strSendtime.PadRight(14, '0');
            // giá trị BANK_CODE         
            strSign += "" + clsCommon.fcnGetENVControl("BANK_CODE").PadRight(12, ' ');
            // giá trị BANK_ID       
            strSign += "" + clsCommon.fcnGetENVControl("BANK_ID").PadRight(8, ' ');
           
            strSign += "" + clsCommon.fcnGetENVControl("O_RPC_ID").PadRight(5, ' ');
            // giá trị res_code bằng rỗng
            strSign += "" + v_strRescode.PadRight(4, 'Z');
            //gía trị rỗng
            strSign += "" + v_strRespone.PadRight(14, '0');
            //MSGNO
            strSign += "" + clsCommon.fcnCreateKey("RE", Application["gstrCI_Date"].ToString().Substring(2, 2));//clsCommon.fcnCreateSerialNo(strDate, clsCommon.fcnGetENVControl("TAD_ID").PadRight(5, ' ')).PadRight(8, ' ');
            // lấy giá trị của TR_CRT_TIME
            strSign += "" + clsCommon.fcnGetENVControl("GLOBAL_DATE").PadRight(8, ' ');
            // gía trị của nó TAD_ID
            strSign += "" + clsCommon.fcnGetENVControl("TAD_ID").PadRight(5, ' ');
            if (strFileName != "")
            {
                strSign += "" + strFileName.PadRight(25, ' ');
            }           
            string E_SIGN = clsCommon.CreateE_Sign(strSign);
            strSign = E_SIGN;
            return strSign;        
        }        

        private void getSaveMess(string strFileName){
            //TBLENV_CONTROLModule mdlTBLENV_CONTROL = new TBLENV_CONTROLModule();
            TBLMESSAGE_QUEUEModule mdlTBLMESSAGE_QUEUE = new TBLMESSAGE_QUEUEModule();
            TBLMESSAGE_QUEUE objecMESSAGE = new TBLMESSAGE_QUEUE();
            //chưa biết lấy đúng chưa
            string sTAD_ID =  clsCommon.fcnGetENVControl("TAD_ID");
            //string strTrxDate = clsCommonf.cnDateToString(DateTime.Now.ToLongDateString());
            // lấy ngày hiện tại chưa biết đúng không yyyymmdd
            //Chua  co trong class TBLMESSAGE_QUEUE
            //objecMESSAGE.STATUS_CODE = "";
            string gTRX_DATE = getDateTimeNow();
            
            //giá trị này là rỗng
            objecMESSAGE.CREATE_BLOCK="";
            //giá trị này chưa biết lấy ở đâu
            objecMESSAGE.ID = clsCommon.fcnCreateKey("","");
            objecMESSAGE.ID = sTAD_ID;
            //chưa xác đinh được sTAD_ID                            
            objecMESSAGE.MSG_CONTENT = clsCommon.fcnMakeMessage(sTAD_ID);
            //giá trị này lây ở đâu
            objecMESSAGE.PRIORITY  =12;
            //chưa biết lây ở đâu
            objecMESSAGE.PROCESS = "P";
            // giá trị này lấy ở đâu
            objecMESSAGE.R_CI_ID = long.Parse(clsCommon.fcnGetENVControl("BANK_ID"));
            //giá trị rỗng
            objecMESSAGE.RESPONSE_CODE = "";
            //lay ngay gio hien tai
            objecMESSAGE.SD_TIME = gTRX_DATE;
            // chưa biết lây ở đâu
            objecMESSAGE.SERIAL_NO  = "";
            // giá trị này bằng rỗng
            objecMESSAGE.SQ = "";
            //lấy không biết có đúng không
            objecMESSAGE.TRX_DATE = getDateTimeNow();
            if (strFileName == "RSERVE")
            {
                objecMESSAGE.TRX_TYPE = "909092";
                //thuộc tính này không có
                //objecMESSAGE.FILE_NAME = strFileName;
            
            }else{
                objecMESSAGE.TRX_TYPE = "510670";
                //thuộc tính này không có
                //objecMESSAGE.FILE_NAME = strFileName;
            
            }  
          

            //ghi du lieu vao tblmessage_queue
            try
            {              
                mdlTBLMESSAGE_QUEUE.Save(objecMESSAGE);
                mdlTBLMESSAGE_QUEUE.Commit();
            }catch(Exception e1){
                
            }
        //clsMess_Con.MSG_TYPE = gMSG_TYPE_FTL
        //    clsMess_Con.STATUS_CODE = "1" //khong thay
        //    clsMess_Con.TR_DATE = gTRX_DATE
        //    clsMess_Con.CI_CODE = gBANK_CODE
        //    clsMess_Con.CI_ID = gBANK_ID
        //    clsMess_Con.O_RPC_ID = gO_RPC_ID
        //    clsMess_Con.RES_CODE = ""
        //    clsMess_Con.RESPONSE_TIME = ""
        //    sTAD_ID = gTAD_ID
        //    clsMess_Con.TR_CRT_TIME = ""
        //    clsMess_Con.TAD_ID = sTAD_ID
        //    For i = 0 To dtFileQueue.Rows.Count - 1
        //        row = dtFileQueue.Rows(i)
        //        If row("FILE_NAME").ToString.Trim = "RSERVE" Then
        //            sSERVICE = "RF_SFN_0102001"
        //            clsMess_Con.FILE_NAME = ""
        //            clsMess_Con.TR_TYPE = "909092"
        //        Else
        //            sSERVICE = "RF_RAA_0102001"
        //            clsMess_Con.FILE_NAME = row("FILE_NAME").ToString
        //            clsMess_Con.TR_TYPE = "510670"
        //        End If
        //        clsMess_Con.SEND_TIME = gTRX_DATE + Now.ToString("HHmmss")
        //        clsMess_Con.MSG_NO = objCom.fcnCreateSerialNo(gTRX_DATE, sTAD_ID, clsDAL)      
            //sRet += _SYS_TYPE.PadRight(4, " "c)
            //sRet += _MSG_TYPE.PadRight(4, " "c)
            //sRet += _TR_TYPE.PadRight(6, " "c)
            //sRet += _STATUS_CODE.PadRight(4, "0"c)
            //sRet += _TR_DATE.PadRight(8, " "c)
            //sRet += _SEND_TIME.PadRight(14, "0"c)
            //sRet += _CI_CODE.PadRight(12, " "c)
            //sRet += _CI_ID.PadRight(8, " "c)
            //sRet += _O_RPC_ID.PadRight(5, " "c)
            //sRet += _RES_CODE.PadRight(4, "Z"c)
            //sRet += _RESPONSE_TIME.PadRight(14, " "c)
            //sRet += _MSG_NO.PadRight(8, " "c)
            //sRet += _TR_CRT_TIME.PadRight(14, "0"c)
            //sRet += _TAD_ID.PadRight(5, " "c)
            //If _FILE_NAME <> "" Then
            //    sRet += _FILE_NAME.PadRight(25, " "c)
            //End If

            //_E_SIGN = ibps_Sign_Message(sRet, _Ikey_Serial, _isValidIkey)
            //sRet += _E_SIGN.PadRight(200, " "c)
        }

        private void addRSERVEFIle()
        {
            TBLFILE_LISTModule mdlTBLFILE_LIST = new TBLFILE_LISTModule();
            TBLFILE_LIST objTBLFILE_LIST = new TBLFILE_LIST();            
            objTBLFILE_LIST.ID = "RSERVE";
            objTBLFILE_LIST.FILE_SIZE = "";
            objTBLFILE_LIST.FILE_KEY = "";
            objTBLFILE_LIST.FILE_STATUS = "09";
            objTBLFILE_LIST.RECORD_COUNT = "";
            objTBLFILE_LIST.SD_TIME = "";
            objTBLFILE_LIST.TRX_DATE = "";
            objTBLFILE_LIST.UPDATE_SUCC = "";

            //strTRC_FILE_NAME = "RSERVE"; 
            //objTBLFILE_REQUEST.TRX_FILE_NAME = strTRC_FILE_NAME;
            //if (Session[strUserName] == null) { return; }
            //objTBLFILE_REQUEST.USER_ID = (string)Session[strUserName];
            //objTBLFILE_REQUEST.ESIGN = v_strESIGN;
            //objTBLFILE_REQUEST.CREATE_TIME = GetDateNow();

            mdlTBLFILE_LIST.Save(objTBLFILE_LIST);
            mdlTBLFILE_LIST.Commit();

            //row("FILE_NAME") = "RSERVE"
            //row("FILE_TYPE") = "09"
            //row("FILE_DESC") = "File dữ liệu từ điển"
            //row("FILE_DESC_EN") = "Synchorous data file"
            //row("FILE_SIZE") = ""
            //row("FILE_STATUS") = "00"

        }
   
        private string getFileStatu(string strStatus,bool check)
        {
            if (strStatus == "00")
            {
                if (check)
                {
                    return "Nhận file thành công"; 
                }
                else
                {
                    return "Receive file succsess"; 
                }
                
            } if (strStatus == "01")
            {
                if (check)
                {
                    return "Cập nhật thành công";
                }
                else
                {
                    return "Update file succsess";
                }
            } if (strStatus == "02")
            {
                if (check)
                {
                    return "Lỗi giải mã file";
                }
                else
                {
                    return "Error decode file";
                }
            } if (strStatus == "03")
            {
                if (check)
                {
                    return "Lỗi cập nhật dữ liệu";
                }
                else
                {
                    return "Error update data";
                }
            }
            else
            {
                return "";
            }
            
        }

        private void subGetFileRequest(int i_intPageIndex)
        {

            string strbytFileList = "SELECT TBLFILE_REQUEST.TRX_FILE_NAME, FILE_TYPE,CREATE_TIME,USER_ID,FILE_STATUS,DESCRIPTION_E,DESCRIPTION_V ";
            clsDAL clsD = new clsDAL();
            DataSet ds = new DataSet();
            if (clsD.DataBaseType == eDataBaseType.ORACLE)
            {
                strbytFileList = strbytFileList + " FROM TBLFILE_LIST ,tblFile_info,  TBLFILE_REQUEST WHERE  substr(TBLFILE_REQUEST.trx_file_name,0,7)=file_name and TBLFILE_REQUEST.TRX_FILE_NAME=TBLFILE_LIST.TRX_FILE_NAME ";
            }
            else
            {
                strbytFileList = strbytFileList + " FROM TBLFILE_LIST ,tblFile_info,  TBLFILE_REQUEST WHERE  substring(TBLFILE_REQUEST.trx_file_name,0,7)=file_name and TBLFILE_REQUEST.TRX_FILE_NAME=TBLFILE_LIST.TRX_FILE_NAME ";
            }


            //Kiem tra xem co so du lieu la sqlServer Hay oracle.


            strbytFileList += " GROUP BY TBLFILE_REQUEST.TRX_FILE_NAME, FILE_TYPE,CREATE_TIME,USER_ID,FILE_STATUS,DESCRIPTION_E,DESCRIPTION_V ORDER BY CREATE_TIME DESC  ";

            ds = clsD.fcnExecQuery(strbytFileList);
            string gridSize = clsCommon.fcnGetENVControl("GRID_SIZE");

            if (gridSize == "")
                grvFileRequest.PageSize = 10;
            else
                grvFileRequest.PageSize = int.Parse(gridSize);

            grvFileRequest.DataSource = ds.Tables[0];
            lblTotalRequest.Text = ds.Tables[0].Rows.Count.ToString();

            grvFileRequest.PageIndex = i_intPageIndex;
            grvFileRequest.DataBind();
            


        }
        #endregion

        #region "event action"

        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                USE_ESIGN = clsCommon.fcnGetENVControl("USE_ESIGN") == "1";
                if (!Page.IsPostBack)
                {                  
                    if (USE_ESIGN) fcnInitESIGN_FUNCTION();
                    string strDate = Application["gstrCI_Date"].ToString();
                    subGetListType();
                    subGetListFile(0);
                    subGetFileRequest(0);
                }
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }

        protected void grvCIList_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            subGetListFile(e.NewPageIndex);
        }        

        protected void grvCIList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            const int COL_STT = 1;
            const int COL_USED = 7;
            const int COL_DATE=5;
            const int COL_DES = 4;
            string strDescript = "DESCRIPTION_E";
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Cells[COL_STT].Text = (grvCIList.PageIndex * grvCIList.PageSize + ++m_intGridIndexFile).ToString();
                bool check = Session["gstrLanguage"] == CitadLanguage.vn;
                e.Row.Cells[COL_USED].Text = getFileStatu(DataBinder.Eval(e.Row.DataItem, "FILE_STATUS").ToString(), check);
                if (check) strDescript = "DESCRIPTION_V";
                e.Row.Cells[COL_DES].Text = DataBinder.Eval(e.Row.DataItem, strDescript).ToString();
                string strDate = DataBinder.Eval(e.Row.DataItem, "TRX_DATE").ToString();
                string strDateTime = "";
                if (strDate.Length >= 8)
                {
                    strDateTime = strDate.Substring(6, 2) + "/" + strDate.Substring(4, 2) + "/" + strDate.Substring(0, 4);

                }
                e.Row.Cells[COL_DATE].Text = strDateTime;               
                e.Row.Attributes.Add("onmouseover", "row_ChangeBackColor(this,true);");
                e.Row.Attributes.Add("onmouseout", "row_ChangeBackColor(this,false);");

            }
            
        }

        protected void cbo_File_Type_SelectedIndexChanged(object sender, EventArgs e)
        {  
            subGetListFile(0); 
        }

        protected void cboCI_Status_SelectedIndexChanged(object sender, EventArgs e)
        {
            subGetListFile(0);
        }

        protected void AllCheckFileType_CheckedChanged(object sender, EventArgs e)
        {
            subGetListFile(0);
        }

        protected void grvFileRequest_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            subGetFileRequest(e.NewPageIndex);
        }

        protected void grvFileRequest_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            const int COL_STT = 0;
            //const int COL_USED = 6;
            const int COL_DATE = 4;
            const int COL_DES = 5;
            int COL_STU = 3;
            string strDescript = "DESCRIPTION_E";
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Cells[COL_STT].Text = (grvFileRequest.PageIndex * grvFileRequest.PageSize + ++m_intGridIndexRequest).ToString();
                bool check = Session["gstrLanguage"] == CitadLanguage.vn;

                e.Row.Cells[COL_STU].Text = getFileStatu(DataBinder.Eval(e.Row.DataItem, "FILE_STATUS").ToString(), check);
                if (check) strDescript = "DESCRIPTION_V";

                e.Row.Cells[COL_DES].Text = DataBinder.Eval(e.Row.DataItem, strDescript).ToString();
                string strDate = DataBinder.Eval(e.Row.DataItem, "CREATE_TIME").ToString();
                string strDateTime = "";
                if (strDate.Length >= 14)
                {
                    strDateTime = strDate.Substring(8, 2) + ":" + strDate.Substring(10, 2) + ":" + strDate.Substring(12, 2) + " ngày ";
                    strDateTime = strDateTime + strDate.Substring(6, 2) + "/" + strDate.Substring(4, 2) + "/" + strDate.Substring(0, 4);
                }
                e.Row.Cells[COL_DATE].Text = strDateTime;
                e.Row.Attributes.Add("onmouseover", "row_ChangeBackColor(this,true);");
                e.Row.Attributes.Add("onmouseout", "row_ChangeBackColor(this,false);");

            }
        }

        protected void cboReserver_CheckedChanged(object sender, EventArgs e)
        {

        }

        protected void Menu1_MenuItemClick(object sender, MenuEventArgs e)
        {
            switch (e.Item.Value)
            {

                case "mnuClose":
                    Response.Redirect("../../");
                    break;
                case "mnuQuery":
                    subGetListFile(0);
                    subGetListFile(0);                    
                    break;
                case "mnuApprove":
                    string v_strFileName ="";
                    string v_strMsgNo="";
                    string v_strMsgContent ="";
                    string v_strType = "";
                    int v_intCount = 0;
                    //==========================================================

                    //==========================================================
                    //Lấy serial người ký duyệt
                    string v_strSERIAL_NUMBER = "";
                    string v_strESIGN = "";
                    if (USE_ESIGN)
                    {
                        v_strSERIAL_NUMBER = clsCommon.fcnGetUSER_CERT(Session["gstrLoginID"].ToString(), Application["gstrCI_ID"].ToString()).ID;
                        if (chkSync.Checked)
                        {
                            v_strType = "909092";
                            //Tao MSG_KEY
                            v_strMsgNo = clsCommon.fcnCreateKey("RE", Application["gstrCI_Date"].ToString().Substring(2, 2));
                            //Tao ESIGN
                            v_strESIGN = getMessageSign(v_strFileName); ;
                            v_strESIGN += Application["gstrCI_Date"].ToString() + DateTime.Now.ToString("HHmmss") + v_strSERIAL_NUMBER;
                            //Them du lieu vao bang TBLFILE_REQUEST
                            fcnInsertToTBLFILE_REQUEST(v_strMsgNo, v_strFileName, v_strESIGN, v_strType);
                            //Tao MSG_CONTENT
                            v_strMsgContent = fcnCreateMsgContent(v_strMsgNo, v_strFileName, v_strESIGN, v_strType);
                            //THem du lieu vao bang TBLMESSAGE_QUEUE
                            fcnInsertToTBLMESSAGE_QUEUE(v_strMsgNo, v_strFileName, v_strType);
                            subGetFileRequest(0);
                        }
                        else
                        {
                            v_strType = "510670";
                        }
                    }
                    //==========================================================
                    foreach (GridViewRow row in grvCIList.Rows)
                    {
                        if (((HtmlInputCheckBox)row.FindControl("chkOne")).Checked)
                        {
                           v_strFileName=grvCIList.DataKeys[row.RowIndex]["TRX_FILE_NAME"].ToString();
                            //===========================================================
                            //Lấy chữ ký ở cột hidESIGN_CONTENT
                            v_strESIGN = ((HiddenField)row.FindControl("hidESIGN_CONTENT")).Value;
                            v_strESIGN += Application["gstrCI_Date"].ToString() + DateTime.Now.ToString("HHmmss") + v_strSERIAL_NUMBER;
                            //===========================================================
                            //Tao MSG_KEY
                            v_strMsgNo = clsCommon.fcnCreateKey("RE", Application["gstrCI_Date"].ToString().Substring(2, 2));
                            //Them du lieu vao bang TBLFILE_REQUEST
                            fcnInsertToTBLFILE_REQUEST(v_strMsgNo,v_strFileName, v_strESIGN,v_strType);
                            //Tao MSG_CONTENT
                            v_strMsgContent=fcnCreateMsgContent(v_strMsgNo, v_strFileName,v_strESIGN,v_strType);
                            //THem du lieu vao bang TBLMESSAGE_QUEUE
                            fcnInsertToTBLMESSAGE_QUEUE(v_strMsgNo, v_strFileName,v_strType);
                            v_intCount += 1;
                        }

                    }
                    if (v_intCount == 0)
                    {
                        MessageBox1.Show("MSG302: " + clsCommon.fcnGetMessage("MSG302"), MessageBoxType.Info);
 
                    }

                    break;
                default:
                    break;
            }
        }
        #endregion

        #region "Nhóm hàm ký duyệt"

        /// <summary>
        /// Hàm tạo nội dung chữ ký
        /// </summary>
        private void fcnInitESIGN_MESSAGE()
        {
            if (Session["ESIGN_IS_APPROVE"].ToString() != "1")
            {
                Menu1.Items[MENUITEM_APPROVE].Enabled = false;
                return;
            }

            foreach (GridViewRow row in grvCIList.Rows)
            {
                if (row.RowType == DataControlRowType.DataRow)
                {
                    ((HiddenField)row.FindControl("hidESIGN_MESSAGE")).Value = getMessageSign(grvCIList.DataKeys[row.RowIndex]["TRX_FILE_NAME"].ToString());
                }
            }
        }

        /// <summary>
        /// Hàm tạo hàm javascript tạo chữ ký
        /// </summary>
        private void fcnInitESIGN_FUNCTION()
        {
            //=============================================================================
            //Kiểm tra quyền có được ký duyệt bản ghi hay không
            string v_strUSER_ID = (string)Session["gstrLoginID"];
            string v_strCI_ID = (string)Application["gstrCI_ID"];
            string v_strCI_DATE = (string)Application["gstrCI_Date"];
            //=============================================================================
            //Kiểm tra thông tin người kiểm soát đến xem có đủ điều kiện duyệt hay không ?
            if (Session["ESIGN_IS_APPROVE"] == null)
            {
                int v_intESIGN_IS_APPROVE = clsCommon.fcnIsApprove_ESIGN(v_strUSER_ID, v_strCI_ID);
                Session["ESIGN_IS_APPROVE"] = v_intESIGN_IS_APPROVE;
            }
            switch ((int)Session["ESIGN_IS_APPROVE"])
            {
                case -1:
                    MessageBox1.Show(clsCommon.fcnGetMessage("MSG275"));//Thông báo Lỗi xử lý hàm kiểm tra
                    break;
                case -2:
                    MessageBox1.Show(clsCommon.fcnGetMessage("MSG276"));//Không tồn tại ngân hàng
                    break;
                case -3:
                    MessageBox1.Show(clsCommon.fcnGetMessage("MSG271"));//Không tồn tại thông tin người ký
                    break;
                case -4:
                    MessageBox1.Show(clsCommon.fcnGetMessage("MSG272"));//Sai MAC
                    break;
                case -5:
                    MessageBox1.Show(clsCommon.fcnGetMessage("MSG273"));//CERT hết hiệu lực
                    break;
            }
            //=============================================================================
            if (Session["ESIGN_IS_APPROVE"].ToString() != "1")
            {
                return;
            }
            //=============================================================================
            //Tạo đối tượng đọc IKEY
            ClientScript.RegisterStartupScript(typeof(Page), "CreatObjIKEY", clsCommon.fcnGetIKEY_OBJECT(Request));
            //=============================================================================
            //Thêm sự kiện hàm ký khi click menu item
            Menu1.Items[MENUITEM_APPROVE].NavigateUrl = "javascript:fcnSign()";
            //=============================================================================
            //=============================================================================
            string v_strMenuName = "ctl00$ContentPlaceHolder1$TabContainer1$TabPanel1$Menu1";
            string v_strJS_function = clsCommon.fcnRegisterFunctionSIGN_LIST(v_strUSER_ID, v_strCI_ID, v_strCI_DATE, COL_ESIGN_MESSAGE, COL_ESIGN_CONTENT, false, v_strMenuName);
            ClientScript.RegisterStartupScript(typeof(Page), "JS_function", v_strJS_function);
            
        }

        #endregion

        #region "Lam Lai"

        #region "Them du lieu vao bang TBLFILE_REQUEST"

        private void fcnInsertToTBLFILE_REQUEST(string strMsgKey,string strFileName,string strEsign,string strType)
        {
            TBLFILE_REQUEST objTBLFILE_REQUEST = new TBLFILE_REQUEST();
            TBLFILE_REQUESTModule mdlTBLFILE_REQUEST = new TBLFILE_REQUESTModule();
            objTBLFILE_REQUEST.ID = strMsgKey;// clsCommon.fcnCreateKey("RE", Application["gstrCI_Date"].ToString().Substring(2, 2));
            objTBLFILE_REQUEST.TRX_TYPE = strType;
            objTBLFILE_REQUEST.TRX_FILE_NAME = strFileName;
            objTBLFILE_REQUEST.USER_ID = Session["gstrLoginID"].ToString();
            objTBLFILE_REQUEST.ESIGN = strEsign;
            mdlTBLFILE_REQUEST.BeginTransaction();
            mdlTBLFILE_REQUEST.Save(objTBLFILE_REQUEST);
            mdlTBLFILE_REQUEST.Commit();
        }

        #endregion

        #region "Them du lieu vao bang TBLMESSAGE_QUEUE"
        // lấy ngày giờ hiện tại trả về dạng  yyyymmddhhmmss
        protected string GetDateNow()
        {
            return Application["gstrCI_Date"].ToString() + DateTime.Now.ToString("HHmmss");
        }

        private string getDateTimeNow()
        {
            string v_strDateTime = Application["gstrCI_Date"].ToString();
            return v_strDateTime;
        }

        private void fcnInsertToTBLMESSAGE_QUEUE(string strMsg_key,string strFileName,string strType)
        {
            TBLMESSAGE_QUEUE objTBLMESSAGE_QUEUE = new TBLMESSAGE_QUEUE();
            TBLMESSAGE_QUEUEModule mdlTBLMESSAGE_QUEUE = new TBLMESSAGE_QUEUEModule();
            objTBLMESSAGE_QUEUE.ID = strMsg_key;
            objTBLMESSAGE_QUEUE.SERIAL_NO = clsCommon.fcnCreateSerialNo(getDateTimeNow(), clsCommon.fcnGetENVControl("TAD_ID").PadRight(5, ' '));
            objTBLMESSAGE_QUEUE.R_CI_ID = long.Parse(clsCommon.fcnGetENVControl("O_RPC_ID"));
            objTBLMESSAGE_QUEUE.CREATE_BLOCK = "";
            objTBLMESSAGE_QUEUE.MSG_CONTENT = "";
            objTBLMESSAGE_QUEUE.PRIORITY = 12;
            objTBLMESSAGE_QUEUE.PROCESS = "F";
            objTBLMESSAGE_QUEUE.RESPONSE_CODE = "";
            objTBLMESSAGE_QUEUE.SD_TIME = "";
            objTBLMESSAGE_QUEUE.SQ = GetDateNow();
            objTBLMESSAGE_QUEUE.TRX_DATE = Application["gstrCI_Date"].ToString();
            objTBLMESSAGE_QUEUE.TRX_TYPE = strType;
            mdlTBLMESSAGE_QUEUE.BeginTransaction();
            mdlTBLMESSAGE_QUEUE.Save(objTBLMESSAGE_QUEUE);
            mdlTBLMESSAGE_QUEUE.Commit();
        }

        private string fcnCreateMsgContent(string strMsg_key,string strFileName,string strEsign,string strType)
        {
            string strSign = "";
            string v_strStatusCode ="";
            string v_strSendtime ="";
            string v_strRescode = "";
            string v_strRespone = "";
            //lay 4 gia system_type 
            strSign += "" + clsCommon.fcnGetENVControl("SYSTEM_CODE").PadRight(4, ' ');
            //lay 4 gia tri msg_type_ftl
            strSign += "" + clsCommon.fcnGetENVControl("MSG_TYPE_FTL").PadRight(4, ' ');
            //TR_TYPE
            strSign += "" + strType.PadRight(6, ' ');
            //Gia tri status code
            strSign += "" + v_strStatusCode.PadRight(4, ' ');
            // giá trị tr_date
            strSign += "" + clsCommon.fcnGetENVControl("GLOBAL_DATE").PadRight(8, ' ');
            //sendtime
            strSign += "" + v_strSendtime.PadRight(14, '0');
            //
            strSign += "" + clsCommon.fcnGetENVControl("BANK_CODE").PadRight(12, ' ');

            strSign += "" + clsCommon.fcnGetENVControl("BANK_ID").PadRight(8, ' '); 
            //8            
            strSign += "" + clsCommon.fcnGetENVControl("O_RPC_ID").PadRight(5, ' ');
            // giá trị res_code bằng rỗng
            strSign += "" + v_strRescode.PadRight(4, 'Z');
            //gía trị rỗng
            strSign += "" + v_strRespone.PadRight(14, '0');
            //MSGNO
            strSign += "" + strMsg_key.PadRight(8, '0');
            //  tra gia trị của bằng rỗng 
            // lấy giá trị của TR_CRT_TIME
            strSign += "" + clsCommon.fcnGetENVControl("GLOBAL_DATE").PadRight(8, ' ');
            // gía trị của nó TAD_ID
            strSign += "" + clsCommon.fcnGetENVControl("TAD_ID").PadRight(5, ' ');
            //string strDate = getDateTimeNow();
            //strSign += "" + clsCommon.fcnCreateSerialNo(strDate, clsCommon.fcnGetENVControl("TAD_ID").PadRight(5, ' ')).PadRight(6, ' ');
            if (strFileName != "")
            {
                strSign += "" + strFileName.PadRight(25, ' ');
            }
            strSign += "" + strEsign;
            return strSign;
        }  

        #endregion

        #endregion
    }
}