﻿<%@ Page Language="C#" MasterPageFile ="~/CITAD.Master" 
    AutoEventWireup="true" 
    CodeBehind="frmWarning.aspx.cs" 
    Inherits="CITAD.Modules.TaoLenhDangKyCanhBao.Web.frmWarning" 
    Culture="auto" 
    meta:resourcekey="PageResource1" 
    UICulture="auto" 
    Title="Đăng ký cảnh báo số dư tài khoản quyết toán"%>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
   
<script type="text/javascript" language="javascript">

 function GetDecimalDelimiter(countryCode)
{
 
  switch (countryCode)
  {
    case 3:   
           return '#';
    case 2:   
           return '.';
    default:
           return '.';
  }
}

function GetCommaDelimiter(countryCode)
{
 
  switch (countryCode)
  { 
    case 3:          
           return '*';
    case 2:   
           return ',';
    default:
           return ',';
  }
 
}

function FormatClean(num)
{
     var sVal='';
     var nVal = num.length;
     var sChar='';
     
   try
   {
      for(c=0;c<nVal;c++)
      {
         sChar = num.charAt(c);
         nChar = sChar.charCodeAt(0);
         if ((nChar >=48) && (nChar <=57))  { sVal += num.charAt(c);   }
      }
   }
    catch (exception) { AlertError("Format Clean",exception); }
    return sVal;
}
  

function FormatNumber(num,countryCode,decimalPlaces)
{       

  var minus='';
  var comma='';
  var dec='';
  var preDecimal='';
  var postDecimal='';
  
  try 
  {
   
    decimalPlaces = parseInt(decimalPlaces);
    comma = GetCommaDelimiter(countryCode);
    dec = GetDecimalDelimiter(countryCode);
    
    if (decimalPlaces < 1) { dec = ''; }
    //if (num.lastIndexOf("-") == 0) { minus='-'; }
    
   
    preDecimal = FormatClean(num);
    
    // preDecimal doesn't contain a number at all.
    // Return formatted zero representation.
    
    if (preDecimal.length < 1)
    {
       return minus + FormatEmptyNumber(dec,decimalPlaces);
    }
    
    // preDecimal is 0 or a series of 0's.
    // Return formatted zero representation.
    
    if (parseInt(preDecimal) < 1)
    {
       return minus + FormatEmptyNumber(dec,decimalPlaces);
    }
    
    // predecimal has no numbers to the left.
    // Return formatted zero representation.
    
    if (preDecimal.length == decimalPlaces)
    {
      return minus + '0' + dec + preDecimal;
    }
    
    // predecimal has fewer characters than the
    // specified number of decimal places.
    // Return formatted leading zero representation.
    
    if (preDecimal.length < decimalPlaces)
    {
       if (decimalPlaces == 2)
       {
        return minus + FormatEmptyNumber(dec,decimalPlaces - 1) + preDecimal;
       }
       return minus + FormatEmptyNumber(dec,decimalPlaces - 2) + preDecimal;
    }
    
    // predecimal contains enough characters to
    // qualify to need decimal points rendered.
    // Parse out the pre and post decimal values
    // for future formatting.
    
    if (preDecimal.length > decimalPlaces)
    {
      postDecimal = dec + preDecimal.substring(preDecimal.length - decimalPlaces,
                                               preDecimal.length);
      preDecimal = preDecimal.substring(0,preDecimal.length - decimalPlaces);
    }

    // Place comma oriented delimiter every 3 characters
    // against the numeric represenation of the "left" side
    // of the decimal representation.  When finished, return
    // both the left side comma formatted value together with
    // the right side decimal formatted value.
    
    var regex  = new RegExp('(-?[0-9]+)([0-9]{3})');
 
    while(regex.test(preDecimal))
    {
       preDecimal = preDecimal.replace(regex, '$1' + comma + '$2');
    }
       
  }
  catch (exception) { AlertError("Format Number",exception); }
  return minus + preDecimal + postDecimal;
}

function FormatEmptyNumber(decimalDelimiter,decimalPlaces)
{
    //var preDecimal = '0';
    var preDecimal = '';
    var postDecimal = '';
 
    for(i=0;i<decimalPlaces;i++)
    {
      if (i==0) { postDecimal += decimalDelimiter; }
      postDecimal += '0';
    }
   return preDecimal + postDecimal;
}
    function AlertError(methodName,e)
    {
        if (e.description == null) { alert(methodName + " Exception: " + e.message); }
        else {  alert(methodName + " Exception: " + e.description); }
    }
	</script>
    <script language ="javascript" type ="text/javascript" >
        window.document.onkeyup=ShortcutKeys;
        function ShortcutKeys()
        {
                if(event.ctrlKey)
                {                    
                    if(window.event.keyCode==37)    //  Trước Ctrl + <--
                    {
                        $get('ctl00$ContentPlaceHolder1$btnPrev1').click();
                    }
                    if(window.event.keyCode==39)    //  Tiếp theo Ctrl + -->
                    {
                        $get('ctl00$ContentPlaceHolder1$btnNext1').click();
                    }
                    if(window.event.keyCode==8)    //  trở về danh sách Ctrl + BackSpace
                    {
                        $get('ctl00$ContentPlaceHolder1$btnClose1').click();
                    }
                    if(window.event.keyCode==52)    //  Truy vấn Ctrl + 4
                    {                        
                        $get('ctl00$ContentPlaceHolder1$btnQuery1').click();
                    }
                }
        }
    </script>
     <div>
         <ajaxToolkit:ToolkitScriptManager runat="Server" EnableScriptGlobalization="True"  EnableScriptLocalization="True" ID="ScriptManager1" CombineScripts="True" />
        <div>
        <asp:UpdatePanel ID="UpdatePanel2" runat="server">
            <ContentTemplate>
            <asp:Label ID="lblError1" runat="server" ForeColor ="Red" meta:resourcekey="lblError1Resource1"></asp:Label>
                <table width="100%">
                    <tr>
                        <td valign="top">
                            <table>
                                <tr>
                                    <td >
                                        <asp:Label ID="lblSerial_No1" runat="server" Text="Số hiệu giao dịch" Width="200px" meta:resourcekey="lblSerial_No1Resource1"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtSerial_No1" runat="server" CssClass="citad-txtReadonly" Width="154px" ReadOnly="True" meta:resourcekey="txtSerial_No1Resource1"></asp:TextBox>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <td >
                                        <asp:Label ID="lblWarningTime" runat="server" Text="Thời điểm cảnh báo" Width="200px" meta:resourcekey="lblWarningTimeResource1"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtWarning_Time" runat="server" CssClass="citad-txtReadonly" Width="154px" ReadOnly="True" meta:resourcekey="txtWarning_TimeResource1"></asp:TextBox>
                                        
                                    </td>
                                    <td style="width: 3px">
                                    </td>
                                </tr>
                                
                                <tr>
                                    <td >
                                        <asp:Label ID="lblWarning_AMT" runat="server" Text="Mức cảnh báo số dư tài khoản" Width="215px" meta:resourcekey="lblWarning_AMTResource1"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtWarning_AMT" runat="server" style="text-align:right" CssClass="citad-txtReadonly" Width="240px" ReadOnly="True" meta:resourcekey="txtWarning_AMTResource1"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td >
                                        <asp:Label ID="lblWarning_Rate" runat="server" Text="Tỷ lệ cảnh báo số dư" Width="215px" meta:resourcekey="lblWarning_RateResource1"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtWarning_Rate" runat="server" style="text-align:right" CssClass="citad-txtReadonly" Width="240px" ReadOnly="True" meta:resourcekey="txtWarning_RateResource1"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Label ID="lblBalance_AMT" runat="server" Text="Số dư tài khoản quyết toán" Width="215px" meta:resourcekey="lblBalance_AMTResource1"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtBalance_AMT" runat="server" style="text-align:right" CssClass="citad-txtReadonly" Width="240px" ReadOnly="True" meta:resourcekey="txtBalance_AMTResource1"></asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td>
                            <asp:Label ID="Label28" runat="server" Text=" " Width="29px" meta:resourcekey="Label28Resource1"></asp:Label>
                        </td>
                        <td valign="top">
                            <table>
                                <tr>
                                    <td>
                                        <asp:Button ID="btnPrev1" runat="server" CssClass="citad-btn" Text="Trước" OnClick="btnPrev1_Click" meta:resourcekey="btnPrev1Resource1" /></td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Button ID="btnNext1" runat="server" CssClass="citad-btn" Text="Tiếp theo" OnClick="btnNext1_Click" meta:resourcekey="btnNext1Resource1" /></td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Button ID="btnQuery1" runat="server" CssClass="citad-btn" Text="Truy vấn" OnClick="btnQuery1_Click" meta:resourcekey="btnQuery1Resource1" /></td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Button ID="btnClose1" runat="server" CssClass="citad-btn" Text="Trang chủ" OnClick="btnClose1_Click" meta:resourcekey="btnClose1Resource1" /></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            <asp:Button ID="hiddenTargetControlForModalPopup" runat="server" meta:resourcekey="hiddenTargetControlForModalPopupResource1"
                Style="display: none" />
            
            <ajaxToolkit:modalpopupextender id="programmaticModalPopup"
                runat="server" backgroundcssclass="modalBackground" 
                behaviorid="programmaticModalPopupBehavior"
                dropshadow="True" 
                dynamicservicepath="" enabled="True" 
                popupcontrolid="programmaticPopup"
                popupdraghandlecontrolid="programmaticPopupDragHandle" 
                repositionmode="RepositionOnWindowScroll"
                targetcontrolid="hiddenTargetControlForModalPopup"> 
                </ajaxToolkit:modalpopupextender>
                <asp:Panel
                    ID="programmaticPopup" runat="server" Style="display: none" 
                    CssClass="modalPopup" Width="400px" meta:resourcekey="programmaticPopupResource1" >
                    <p style="font-size:14px;">
                        <asp:Label ID="lblThongBao" runat="server" Font-Bold="True" Text="Th&#244;ng b&#225;o" meta:resourcekey="lblThongBaoResource1"></asp:Label>
                    </p>
                    <p>
                        <asp:Label ID="lblTitle" runat="server"  Text="-------------" meta:resourcekey="lblTitleResource1"></asp:Label>
                    </p>
                    <p style="text-align: center;">
                        <asp:Button ID="btnMsgBoxOK" runat="server" Text="OK"  CssClass="citad-btn" Width="81px" OnClick="btnMsgBoxOK_Click" meta:resourcekey="btnMsgBoxOKResource1" />
                    </p>
                </asp:Panel>
            </ContentTemplate>
        </asp:UpdatePanel>
        </div>
        <input id="txtMsg_key" runat ="server"  type= "hidden" enableviewstate="true" style="width: 30px"  />
        <input id="txtMsg_key1" runat ="server"  type= "hidden" enableviewstate="true" style="width: 30px"  />
        <input id="txtOCI_Code" runat ="server"  type= "hidden" enableviewstate="true" style="width: 30px"  />
        <input id="txtO_CI_ID" runat ="server"  type= "hidden" enableviewstate="true" style="width: 30px"  />
        <input id="txtTrx_Date" runat ="server"  type= "hidden" enableviewstate="true" style="width: 30px"  />
        <input id="txtTrx_Status" runat ="server"  type= "hidden" enableviewstate="true" style="width: 30px"  />
        <input id="txtProcess" runat ="server"  type= "hidden" enableviewstate="true" style="width: 30px"  />
    </div>
</asp:Content>
